/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatFactory;
import org.apache.camel.spi.DataFormatResolver;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.support.ResolverHelper;

public class DefaultDataFormatResolver
implements DataFormatResolver {
    public static final String DATAFORMAT_RESOURCE_PATH = "META-INF/services/org/apache/camel/dataformat/";
    private FactoryFinder dataformatFactory;

    public DataFormat resolveDataFormat(String name, CamelContext context) {
        DataFormat dataFormat = ResolverHelper.lookupDataFormatInRegistryWithFallback((CamelContext)context, (String)name);
        if (dataFormat == null) {
            dataFormat = this.createDataFormat(name, context);
        }
        return dataFormat;
    }

    public DataFormat createDataFormat(String name, CamelContext context) {
        DataFormat dataFormat = null;
        DataFormatFactory dataFormatFactory = ResolverHelper.lookupDataFormatFactoryInRegistryWithFallback((CamelContext)context, (String)name);
        if (dataFormatFactory != null) {
            dataFormat = dataFormatFactory.newInstance();
        }
        if (dataFormat == null) {
            dataFormat = this.createDataFormatFromResource(name, context);
        }
        return dataFormat;
    }

    private DataFormat createDataFormatFromResource(String name, CamelContext context) {
        DataFormat dataFormat = null;
        Class type = null;
        try {
            if (this.dataformatFactory == null) {
                this.dataformatFactory = context.getFactoryFinder(DATAFORMAT_RESOURCE_PATH);
            }
            type = this.dataformatFactory.findClass(name);
        }
        catch (NoFactoryAvailableException noFactoryAvailableException) {
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid URI, no DataFormat registered for scheme: " + name, e);
        }
        if (type == null) {
            type = context.getClassResolver().resolveClass(name);
        }
        if (type != null) {
            if (DataFormat.class.isAssignableFrom(type)) {
                dataFormat = (DataFormat)context.getInjector().newInstance(type);
            } else {
                throw new IllegalArgumentException("Resolving dataformat: " + name + " detected type conflict: Not a DataFormat implementation. Found: " + type.getName());
            }
        }
        return dataFormat;
    }
}

