/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointAware;
import org.apache.camel.Exchange;
import org.apache.camel.FailedToCreateConsumerException;
import org.apache.camel.PollingConsumer;
import org.apache.camel.impl.DefaultEndpointUtilizationStatistics;
import org.apache.camel.impl.ServicePool;
import org.apache.camel.spi.ConsumerCache;
import org.apache.camel.spi.EndpointUtilizationStatistics;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;

public class DefaultConsumerCache
extends ServiceSupport
implements ConsumerCache {
    private final CamelContext camelContext;
    private final ServicePool<PollingConsumer> consumers;
    private final Object source;
    private EndpointUtilizationStatistics statistics;
    private boolean extendedStatistics;
    private int maxCacheSize;

    public DefaultConsumerCache(Object source, CamelContext camelContext, int cacheSize) {
        this.source = source;
        this.camelContext = camelContext;
        this.maxCacheSize = cacheSize == 0 ? CamelContextHelper.getMaximumCachePoolSize((CamelContext)camelContext) : cacheSize;
        this.consumers = new ServicePool<PollingConsumer>(Endpoint::createPollingConsumer, EndpointAware::getEndpoint, this.maxCacheSize);
        this.extendedStatistics = camelContext.getManagementStrategy().getManagementAgent() != null ? camelContext.getManagementStrategy().getManagementAgent().getStatisticsLevel().isExtended() : false;
    }

    public boolean isExtendedStatistics() {
        return this.extendedStatistics;
    }

    public void setExtendedStatistics(boolean extendedStatistics) {
        this.extendedStatistics = extendedStatistics;
    }

    public void releasePollingConsumer(Endpoint endpoint, PollingConsumer pollingConsumer) {
        this.consumers.release(endpoint, pollingConsumer);
    }

    public PollingConsumer acquirePollingConsumer(Endpoint endpoint) {
        try {
            PollingConsumer consumer = this.consumers.acquire(endpoint);
            if (this.statistics != null) {
                this.statistics.onHit(endpoint.getEndpointUri());
            }
            return consumer;
        }
        catch (Throwable e) {
            throw new FailedToCreateConsumerException(endpoint, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exchange receive(Endpoint endpoint) {
        this.log.debug("<<<< {}", (Object)endpoint);
        PollingConsumer consumer = null;
        try {
            consumer = this.acquirePollingConsumer(endpoint);
            Exchange exchange = consumer.receive();
            return exchange;
        }
        finally {
            if (consumer != null) {
                this.releasePollingConsumer(endpoint, consumer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exchange receive(Endpoint endpoint, long timeout) {
        this.log.debug("<<<< {}", (Object)endpoint);
        PollingConsumer consumer = null;
        try {
            consumer = this.acquirePollingConsumer(endpoint);
            Exchange exchange = consumer.receive(timeout);
            return exchange;
        }
        finally {
            if (consumer != null) {
                this.releasePollingConsumer(endpoint, consumer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exchange receiveNoWait(Endpoint endpoint) {
        this.log.debug("<<<< {}", (Object)endpoint);
        PollingConsumer consumer = null;
        try {
            consumer = this.acquirePollingConsumer(endpoint);
            Exchange exchange = consumer.receiveNoWait();
            return exchange;
        }
        finally {
            if (consumer != null) {
                this.releasePollingConsumer(endpoint, consumer);
            }
        }
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public Object getSource() {
        return this.source;
    }

    public int size() {
        int size = this.consumers.size();
        this.log.trace("size = {}", (Object)size);
        return size;
    }

    public int getCapacity() {
        return this.consumers.getMaxCacheSize();
    }

    public long getHits() {
        return this.consumers.getHits();
    }

    public long getMisses() {
        return this.consumers.getMisses();
    }

    public long getEvicted() {
        return this.consumers.getEvicted();
    }

    public void resetCacheStatistics() {
        this.consumers.resetStatistics();
        if (this.statistics != null) {
            this.statistics.clear();
        }
    }

    public synchronized void purge() {
        try {
            this.consumers.stop();
            this.consumers.start();
        }
        catch (Exception e) {
            this.log.debug("Error restarting consumer pool", (Throwable)e);
        }
        if (this.statistics != null) {
            this.statistics.clear();
        }
    }

    public void cleanUp() {
        this.consumers.cleanUp();
    }

    public EndpointUtilizationStatistics getEndpointUtilizationStatistics() {
        return this.statistics;
    }

    public String toString() {
        return "ConsumerCache for source: " + this.source + ", capacity: " + this.getCapacity();
    }

    protected void doStart() throws Exception {
        if (this.extendedStatistics) {
            int max = this.maxCacheSize == 0 ? CamelContextHelper.getMaximumCachePoolSize((CamelContext)this.camelContext) : this.maxCacheSize;
            this.statistics = new DefaultEndpointUtilizationStatistics(max);
        }
        ServiceHelper.startService(this.consumers);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.statistics, this.consumers});
        if (this.statistics != null) {
            this.statistics.clear();
        }
    }
}

