/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.List;
import java.util.Map;
import javax.naming.Context;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointAware;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Producer;
import org.apache.camel.TypeConverter;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.impl.AbstractCamelContext;
import org.apache.camel.impl.DefaultAsyncProcessorAwaitManager;
import org.apache.camel.impl.DefaultCamelBeanPostProcessor;
import org.apache.camel.impl.DefaultCamelContextNameStrategy;
import org.apache.camel.impl.DefaultClassResolver;
import org.apache.camel.impl.DefaultComponentResolver;
import org.apache.camel.impl.DefaultDataFormatResolver;
import org.apache.camel.impl.DefaultEndpointRegistry;
import org.apache.camel.impl.DefaultExecutorServiceManager;
import org.apache.camel.impl.DefaultFactoryFinderResolver;
import org.apache.camel.impl.DefaultInflightRepository;
import org.apache.camel.impl.DefaultInjector;
import org.apache.camel.impl.DefaultLanguageResolver;
import org.apache.camel.impl.DefaultManagementNameStrategy;
import org.apache.camel.impl.DefaultMessageHistoryFactory;
import org.apache.camel.impl.DefaultModelJAXBContextFactory;
import org.apache.camel.impl.DefaultNodeIdFactory;
import org.apache.camel.impl.DefaultPackageScanClassResolver;
import org.apache.camel.impl.DefaultProcessorFactory;
import org.apache.camel.impl.DefaultRestRegistry;
import org.apache.camel.impl.DefaultRouteController;
import org.apache.camel.impl.DefaultShutdownStrategy;
import org.apache.camel.impl.DefaultStreamCachingStrategy;
import org.apache.camel.impl.DefaultTransformerRegistry;
import org.apache.camel.impl.DefaultUnitOfWorkFactory;
import org.apache.camel.impl.DefaultUuidGenerator;
import org.apache.camel.impl.DefaultValidatorRegistry;
import org.apache.camel.impl.EndpointKey;
import org.apache.camel.impl.HeadersMapFactoryResolver;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.impl.ServicePool;
import org.apache.camel.impl.WebSpherePackageScanClassResolver;
import org.apache.camel.impl.converter.FastTypeConverterRegistry;
import org.apache.camel.impl.health.DefaultHealthCheckRegistry;
import org.apache.camel.impl.transformer.TransformerKey;
import org.apache.camel.impl.validator.ValidatorKey;
import org.apache.camel.model.transformer.TransformerDefinition;
import org.apache.camel.model.validator.ValidatorDefinition;
import org.apache.camel.runtimecatalog.RuntimeCamelCatalog;
import org.apache.camel.runtimecatalog.impl.DefaultRuntimeCamelCatalog;
import org.apache.camel.spi.AsyncProcessorAwaitManager;
import org.apache.camel.spi.BeanRepository;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.CamelContextNameStrategy;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.spi.DataFormatResolver;
import org.apache.camel.spi.EndpointRegistry;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.FactoryFinderResolver;
import org.apache.camel.spi.HeadersMapFactory;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.LanguageResolver;
import org.apache.camel.spi.ManagementNameStrategy;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.spi.ModelJAXBContextFactory;
import org.apache.camel.spi.NodeIdFactory;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.ProcessorFactory;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.RestRegistry;
import org.apache.camel.spi.RouteController;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.spi.StreamCachingStrategy;
import org.apache.camel.spi.TransformerRegistry;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.spi.UnitOfWorkFactory;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.spi.ValidatorRegistry;
import org.apache.camel.support.DefaultRegistry;

public class DefaultCamelContext
extends AbstractCamelContext {
    public DefaultCamelContext() {
    }

    public DefaultCamelContext(BeanRepository repository) {
        super((Registry)new DefaultRegistry(new BeanRepository[]{repository}));
    }

    @Deprecated
    public DefaultCamelContext(Context jndiContext) {
        this(new JndiRegistry(jndiContext));
    }

    public DefaultCamelContext(Registry registry) {
        super(registry);
    }

    public DefaultCamelContext(boolean init) {
        super(init);
    }

    @Override
    protected TypeConverter createTypeConverter() {
        FastTypeConverterRegistry answer = new FastTypeConverterRegistry();
        answer.setCamelContext((CamelContext)this);
        this.setTypeConverterRegistry((TypeConverterRegistry)answer);
        return answer;
    }

    @Override
    protected TypeConverterRegistry createTypeConverterRegistry() {
        TypeConverter typeConverter = this.getTypeConverter();
        if (typeConverter instanceof TypeConverterRegistry) {
            return (TypeConverterRegistry)typeConverter;
        }
        return null;
    }

    @Override
    protected Injector createInjector() {
        FactoryFinder finder = this.getDefaultFactoryFinder();
        try {
            return (Injector)finder.newInstance("Injector");
        }
        catch (NoFactoryAvailableException e) {
            return new DefaultInjector(this);
        }
    }

    @Override
    protected CamelBeanPostProcessor createBeanPostProcessor() {
        return new DefaultCamelBeanPostProcessor(this);
    }

    @Override
    protected ComponentResolver createComponentResolver() {
        return new DefaultComponentResolver();
    }

    @Override
    protected Registry createRegistry() {
        return new DefaultRegistry();
    }

    @Override
    protected UuidGenerator createUuidGenerator() {
        return new DefaultUuidGenerator();
    }

    @Override
    protected ModelJAXBContextFactory createModelJAXBContextFactory() {
        return new DefaultModelJAXBContextFactory();
    }

    @Override
    protected NodeIdFactory createNodeIdFactory() {
        return new DefaultNodeIdFactory();
    }

    @Override
    protected FactoryFinderResolver createFactoryFinderResolver() {
        return new DefaultFactoryFinderResolver();
    }

    @Override
    protected ClassResolver createClassResolver() {
        return new DefaultClassResolver(this);
    }

    @Override
    protected ProcessorFactory createProcessorFactory() {
        return new DefaultProcessorFactory();
    }

    @Override
    protected DataFormatResolver createDataFormatResolver() {
        return new DefaultDataFormatResolver();
    }

    @Override
    protected MessageHistoryFactory createMessageHistoryFactory() {
        return new DefaultMessageHistoryFactory();
    }

    @Override
    protected InflightRepository createInflightRepository() {
        return new DefaultInflightRepository();
    }

    @Override
    protected AsyncProcessorAwaitManager createAsyncProcessorAwaitManager() {
        return new DefaultAsyncProcessorAwaitManager();
    }

    @Override
    protected RouteController createRouteController() {
        return new DefaultRouteController(this);
    }

    @Override
    protected HealthCheckRegistry createHealthCheckRegistry() {
        return new DefaultHealthCheckRegistry((CamelContext)this);
    }

    @Override
    protected ShutdownStrategy createShutdownStrategy() {
        return new DefaultShutdownStrategy(this);
    }

    @Override
    protected PackageScanClassResolver createPackageScanClassResolver() {
        DefaultPackageScanClassResolver packageScanClassResolver;
        if (WebSpherePackageScanClassResolver.isWebSphereClassLoader(this.getClass().getClassLoader())) {
            this.log.info("Using WebSphere specific PackageScanClassResolver");
            packageScanClassResolver = new WebSpherePackageScanClassResolver("META-INF/services/org/apache/camel/TypeConverter");
        } else {
            packageScanClassResolver = new DefaultPackageScanClassResolver();
        }
        return packageScanClassResolver;
    }

    @Override
    protected ExecutorServiceManager createExecutorServiceManager() {
        return new DefaultExecutorServiceManager(this);
    }

    @Override
    protected ServicePool<Producer> createProducerServicePool() {
        return new ServicePool<Producer>(Endpoint::createProducer, EndpointAware::getEndpoint, 100);
    }

    @Override
    protected ServicePool<PollingConsumer> createPollingConsumerServicePool() {
        return new ServicePool<PollingConsumer>(Endpoint::createPollingConsumer, EndpointAware::getEndpoint, 100);
    }

    @Override
    protected UnitOfWorkFactory createUnitOfWorkFactory() {
        return new DefaultUnitOfWorkFactory();
    }

    @Override
    protected RuntimeCamelCatalog createRuntimeCamelCatalog() {
        return new DefaultRuntimeCamelCatalog((CamelContext)this, true);
    }

    @Override
    protected CamelContextNameStrategy createCamelContextNameStrategy() {
        return new DefaultCamelContextNameStrategy();
    }

    @Override
    protected ManagementNameStrategy createManagementNameStrategy() {
        return new DefaultManagementNameStrategy(this);
    }

    @Override
    protected HeadersMapFactory createHeadersMapFactory() {
        return new HeadersMapFactoryResolver().resolve(this);
    }

    @Override
    protected LanguageResolver createLanguageResolver() {
        return new DefaultLanguageResolver();
    }

    @Override
    protected RestRegistry createRestRegistry() {
        return new DefaultRestRegistry();
    }

    @Override
    protected EndpointRegistry<EndpointKey> createEndpointRegistry(Map<EndpointKey, Endpoint> endpoints) {
        return new DefaultEndpointRegistry((CamelContext)this, endpoints);
    }

    @Override
    protected ValidatorRegistry<ValidatorKey> createValidatorRegistry(List<ValidatorDefinition> validators) throws Exception {
        return new DefaultValidatorRegistry((CamelContext)this, validators);
    }

    @Override
    protected TransformerRegistry<TransformerKey> createTransformerRegistry(List<TransformerDefinition> transformers) throws Exception {
        return new DefaultTransformerRegistry((CamelContext)this, transformers);
    }

    @Override
    protected StreamCachingStrategy createStreamCachingStrategy() {
        return new DefaultStreamCachingStrategy();
    }
}

