/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import org.apache.camel.BeanInject;
import org.apache.camel.BindToRegistry;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.EndpointInject;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.Produce;
import org.apache.camel.PropertyInject;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConverter;
import org.apache.camel.impl.CamelPostProcessorHelper;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ReflectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCamelBeanPostProcessor
implements CamelBeanPostProcessor {
    protected static final Logger LOG = LoggerFactory.getLogger(DefaultCamelBeanPostProcessor.class);
    protected CamelPostProcessorHelper camelPostProcessorHelper;
    protected CamelContext camelContext;

    public DefaultCamelBeanPostProcessor() {
    }

    public DefaultCamelBeanPostProcessor(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws Exception {
        LOG.trace("Camel bean processing before initialization for bean: {}", (Object)beanName);
        if (!this.canPostProcessBean(bean, beanName)) {
            return bean;
        }
        this.injectClass(bean, beanName);
        this.injectNestedClasses(bean, beanName);
        this.injectFields(bean, beanName);
        this.injectMethods(bean, beanName);
        if (bean instanceof CamelContextAware && this.canSetCamelContext(bean, beanName)) {
            CamelContextAware contextAware = (CamelContextAware)bean;
            DeferredContextBinding deferredBinding = bean.getClass().getAnnotation(DeferredContextBinding.class);
            CamelContext context = this.getOrLookupCamelContext();
            if (context == null && deferredBinding == null) {
                LOG.warn("No CamelContext defined yet so cannot inject into bean: {}", (Object)beanName);
            } else if (context != null) {
                contextAware.setCamelContext(context);
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws Exception {
        LOG.trace("Camel bean processing after initialization for bean: {}", (Object)beanName);
        if (!this.canPostProcessBean(bean, beanName)) {
            return bean;
        }
        if (bean instanceof DefaultEndpoint) {
            DefaultEndpoint defaultEndpoint = (DefaultEndpoint)bean;
            defaultEndpoint.setEndpointUriIfNotSpecified(beanName);
        }
        return bean;
    }

    public CamelContext getOrLookupCamelContext() {
        return this.camelContext;
    }

    public CamelPostProcessorHelper getPostProcessorHelper() {
        if (this.camelPostProcessorHelper == null) {
            this.camelPostProcessorHelper = new CamelPostProcessorHelper(this.getOrLookupCamelContext());
        }
        return this.camelPostProcessorHelper;
    }

    protected boolean canPostProcessBean(Object bean, String beanName) {
        return bean != null;
    }

    protected boolean canSetCamelContext(Object bean, String beanName) {
        CamelContextAware camelContextAware;
        CamelContext context;
        if (bean instanceof CamelContextAware && (context = (camelContextAware = (CamelContextAware)bean).getCamelContext()) != null) {
            LOG.trace("CamelContext already set on bean with id [{}]. Will keep existing CamelContext on bean.", (Object)beanName);
            return false;
        }
        return true;
    }

    protected void injectFields(final Object bean, final String beanName) {
        ReflectionHelper.doWithFields(bean.getClass(), (ReflectionHelper.FieldCallback)new ReflectionHelper.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                BindToRegistry bind;
                Produce produce;
                EndpointInject endpointInject;
                BeanInject beanInject;
                PropertyInject propertyInject = field.getAnnotation(PropertyInject.class);
                if (propertyInject != null && DefaultCamelBeanPostProcessor.this.getPostProcessorHelper().matchContext(propertyInject.context())) {
                    DefaultCamelBeanPostProcessor.this.injectFieldProperty(field, propertyInject.value(), propertyInject.defaultValue(), bean, beanName);
                }
                if ((beanInject = field.getAnnotation(BeanInject.class)) != null && DefaultCamelBeanPostProcessor.this.getPostProcessorHelper().matchContext(beanInject.context())) {
                    DefaultCamelBeanPostProcessor.this.injectFieldBean(field, beanInject.value(), bean, beanName);
                }
                if ((endpointInject = field.getAnnotation(EndpointInject.class)) != null && DefaultCamelBeanPostProcessor.this.getPostProcessorHelper().matchContext(endpointInject.context())) {
                    String uri = endpointInject.value().isEmpty() ? endpointInject.uri() : endpointInject.value();
                    DefaultCamelBeanPostProcessor.this.injectField(field, uri, endpointInject.property(), bean, beanName);
                }
                if ((produce = field.getAnnotation(Produce.class)) != null && DefaultCamelBeanPostProcessor.this.getPostProcessorHelper().matchContext(produce.context())) {
                    String uri = produce.value().isEmpty() ? produce.uri() : produce.value();
                    DefaultCamelBeanPostProcessor.this.injectField(field, uri, produce.property(), bean, beanName, produce.binding());
                }
                if ((bind = field.getAnnotation(BindToRegistry.class)) != null && DefaultCamelBeanPostProcessor.this.getPostProcessorHelper().matchContext(bind.context())) {
                    DefaultCamelBeanPostProcessor.this.bindToRegistry(field, bind.value(), bean, beanName);
                }
            }
        });
    }

    public void injectField(Field field, String endpointUri, String endpointProperty, Object bean, String beanName) {
        this.injectField(field, endpointUri, endpointProperty, bean, beanName, true);
    }

    public void injectField(Field field, String endpointUri, String endpointProperty, Object bean, String beanName, boolean binding) {
        ReflectionHelper.setField((Field)field, (Object)bean, (Object)this.getPostProcessorHelper().getInjectionValue(field.getType(), endpointUri, endpointProperty, field.getName(), bean, beanName, binding));
    }

    public void injectFieldBean(Field field, String name, Object bean, String beanName) {
        ReflectionHelper.setField((Field)field, (Object)bean, (Object)this.getPostProcessorHelper().getInjectionBeanValue(field.getType(), name));
    }

    public void injectFieldProperty(Field field, String propertyName, String propertyDefaultValue, Object bean, String beanName) {
        ReflectionHelper.setField((Field)field, (Object)bean, (Object)this.getPostProcessorHelper().getInjectionPropertyValue(field.getType(), propertyName, propertyDefaultValue, field.getName(), bean, beanName));
    }

    protected void injectMethods(final Object bean, final String beanName) {
        ReflectionHelper.doWithMethods(bean.getClass(), (ReflectionHelper.MethodCallback)new ReflectionHelper.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                DefaultCamelBeanPostProcessor.this.setterInjection(method, bean, beanName);
                DefaultCamelBeanPostProcessor.this.getPostProcessorHelper().consumerInjection(method, bean, beanName);
            }
        });
    }

    protected void injectClass(Object bean, String beanName) {
        Class<?> clazz = bean.getClass();
        BindToRegistry ann = clazz.getAnnotation(BindToRegistry.class);
        if (ann != null && this.getPostProcessorHelper().matchContext(ann.context())) {
            this.bindToRegistry(clazz, ann.value(), bean, beanName);
        }
    }

    protected void injectNestedClasses(Object bean, String beanName) {
        ReflectionHelper.doWithClasses(bean.getClass(), (ReflectionHelper.ClassCallback)new ReflectionHelper.ClassCallback(){

            public void doWith(Class clazz) throws IllegalArgumentException, IllegalAccessException {
                BindToRegistry ann = clazz.getAnnotation(BindToRegistry.class);
                if (ann != null && DefaultCamelBeanPostProcessor.this.getPostProcessorHelper().matchContext(ann.context())) {
                    DefaultCamelBeanPostProcessor.this.bindToRegistry(clazz, ann.value(), null, null);
                }
            }
        });
    }

    protected void setterInjection(Method method, Object bean, String beanName) {
        BindToRegistry bind;
        Produce produce;
        EndpointInject endpointInject;
        BeanInject beanInject;
        PropertyInject propertyInject = method.getAnnotation(PropertyInject.class);
        if (propertyInject != null && this.getPostProcessorHelper().matchContext(propertyInject.context())) {
            this.setterPropertyInjection(method, propertyInject.value(), propertyInject.defaultValue(), bean, beanName);
        }
        if ((beanInject = method.getAnnotation(BeanInject.class)) != null && this.getPostProcessorHelper().matchContext(beanInject.context())) {
            this.setterBeanInjection(method, beanInject.value(), bean, beanName);
        }
        if ((endpointInject = method.getAnnotation(EndpointInject.class)) != null && this.getPostProcessorHelper().matchContext(endpointInject.context())) {
            String uri = endpointInject.value().isEmpty() ? endpointInject.uri() : endpointInject.value();
            this.setterInjection(method, bean, beanName, uri, endpointInject.property());
        }
        if ((produce = method.getAnnotation(Produce.class)) != null && this.getPostProcessorHelper().matchContext(produce.context())) {
            String uri = produce.value().isEmpty() ? produce.uri() : produce.value();
            this.setterInjection(method, bean, beanName, uri, produce.property());
        }
        if ((bind = method.getAnnotation(BindToRegistry.class)) != null && this.getPostProcessorHelper().matchContext(bind.context())) {
            this.bindToRegistry(method, bind.value(), bean, beanName);
        }
    }

    public void setterInjection(Method method, Object bean, String beanName, String endpointUri, String endpointProperty) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1) {
            LOG.warn("Ignoring badly annotated method for injection due to incorrect number of parameters: {}", (Object)method);
        } else {
            String propertyName = ObjectHelper.getPropertyName((Method)method);
            Object value = this.getPostProcessorHelper().getInjectionValue(parameterTypes[0], endpointUri, endpointProperty, propertyName, bean, beanName);
            org.apache.camel.support.ObjectHelper.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{value});
        }
    }

    public void setterPropertyInjection(Method method, String propertyValue, String propertyDefaultValue, Object bean, String beanName) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1) {
            LOG.warn("Ignoring badly annotated method for injection due to incorrect number of parameters: {}", (Object)method);
        } else {
            String propertyName = ObjectHelper.getPropertyName((Method)method);
            Object value = this.getPostProcessorHelper().getInjectionPropertyValue(parameterTypes[0], propertyValue, propertyDefaultValue, propertyName, bean, beanName);
            org.apache.camel.support.ObjectHelper.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{value});
        }
    }

    public void setterBeanInjection(Method method, String name, Object bean, String beanName) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1) {
            LOG.warn("Ignoring badly annotated method for injection due to incorrect number of parameters: {}", (Object)method);
        } else {
            Object value = this.getPostProcessorHelper().getInjectionBeanValue(parameterTypes[0], name);
            org.apache.camel.support.ObjectHelper.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{value});
        }
    }

    private void bindToRegistry(Class<?> clazz, String name, Object bean, String beanName) {
        if (ObjectHelper.isEmpty((Object)name)) {
            name = clazz.getSimpleName();
        }
        if (bean == null) {
            bean = this.camelContext.getInjector().newInstance(clazz);
        }
        this.camelContext.getRegistry().bind(name, bean);
    }

    private void bindToRegistry(Field field, String name, Object bean, String beanName) {
        Object value;
        if (ObjectHelper.isEmpty((Object)name)) {
            name = field.getName();
        }
        if ((value = ReflectionHelper.getField((Field)field, (Object)bean)) != null) {
            this.camelContext.getRegistry().bind(name, value);
        }
    }

    private void bindToRegistry(Method method, String name, Object bean, String beanName) {
        Class<?> returnType;
        if (ObjectHelper.isEmpty((Object)name)) {
            name = method.getName();
        }
        if ((returnType = method.getReturnType()) == null || returnType == Void.TYPE) {
            throw new IllegalArgumentException("@BindToRegistry on class: " + method.getDeclaringClass() + " method: " + method.getName() + " with void return type is not allowed");
        }
        Object[] parameters = this.bindToRegistryParameterMapping(method);
        Object value = parameters != null ? org.apache.camel.support.ObjectHelper.invokeMethod((Method)method, (Object)bean, (Object[])parameters) : org.apache.camel.support.ObjectHelper.invokeMethod((Method)method, (Object)bean, (Object[])new Object[0]);
        if (value != null) {
            this.camelContext.getRegistry().bind(name, value);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object[] bindToRegistryParameterMapping(Method method) {
        if (method.getParameterCount() == 0) {
            return null;
        }
        Object[] parameters = new Object[method.getParameterCount()];
        for (int i = 0; i < method.getParameterCount(); ++i) {
            Class<Object> type = method.getParameterTypes()[i];
            if (type.isAssignableFrom(CamelContext.class)) {
                parameters[i] = this.camelContext;
            } else if (type.isAssignableFrom(Registry.class)) {
                parameters[i] = this.camelContext.getRegistry();
            } else if (type.isAssignableFrom(TypeConverter.class)) {
                parameters[i] = this.camelContext.getTypeConverter();
            } else {
                Annotation[] anns = method.getParameterAnnotations()[i];
                if (anns.length == 1) {
                    Object value;
                    String key;
                    Annotation ann = anns[0];
                    if (ann.annotationType() == PropertyInject.class) {
                        PropertyInject pi = (PropertyInject)ann;
                        key = pi.value();
                        if (!ObjectHelper.isEmpty((Object)pi.defaultValue())) {
                            key = key + ":" + pi.defaultValue();
                        }
                        key = this.camelContext.getPropertiesComponent().getPrefixToken() + key + this.camelContext.getPropertiesComponent().getSuffixToken();
                        try {
                            value = this.camelContext.resolvePropertyPlaceholders(key);
                            parameters[i] = this.camelContext.getTypeConverter().convertTo(type, value);
                        }
                        catch (Exception e) {
                            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
                        }
                    } else if (ann.annotationType() == BeanInject.class) {
                        BeanInject bi = (BeanInject)ann;
                        key = bi.value();
                        if (ObjectHelper.isEmpty((Object)key)) {
                            Set instances = this.camelContext.getRegistry().findByType(type);
                            if (instances.size() == 0) {
                                throw new NoSuchBeanException(null, key);
                            }
                            if (instances.size() != 1) throw new IllegalArgumentException("Multiple beans of the same type: " + type + " exists in the Camel registry. Specify the bean name on @BeanInject to bind to a single bean, at the method: " + method);
                            parameters[i] = instances.iterator().next();
                        } else {
                            value = this.camelContext.getRegistry().lookupByName(key);
                            if (value == null) {
                                throw new NoSuchBeanException(key);
                            }
                            parameters[i] = this.camelContext.getTypeConverter().convertTo(type, value);
                        }
                    }
                }
            }
            if (parameters[i] != null) continue;
            int pos = i + 1;
            throw new IllegalArgumentException("@BindToProperty cannot bind parameter #" + pos + " on method: " + method);
        }
        return parameters;
    }
}

