/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Iterator;
import java.util.NoSuchElementException;

class CompoundIterator<T>
implements Iterator<T> {
    final Iterator<Iterator<T>> it;
    Iterator<T> current;

    public CompoundIterator(Iterable<Iterator<T>> it) {
        this(it.iterator());
    }

    public CompoundIterator(Iterator<Iterator<T>> it) {
        this.it = it;
        this.current = it.hasNext() ? it.next() : null;
    }

    @Override
    public boolean hasNext() {
        while (this.current != null) {
            if (this.current.hasNext()) {
                return true;
            }
            this.current = this.it.hasNext() ? this.it.next() : null;
        }
        return false;
    }

    @Override
    public T next() {
        if (this.current != null) {
            return this.current.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        this.current.remove();
    }
}

