/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.test;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.WrappedFile;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.ObjectHelper;

@UriEndpoint(firstVersion="1.3.0", scheme="test", title="Test", syntax="test:name", producerOnly=true, label="core,testing", lenientProperties=true)
public class TestEndpoint
extends MockEndpoint {
    private Endpoint expectedMessageEndpoint;
    @UriPath(description="Name of endpoint to lookup in the registry to use for polling messages used for testing")
    @Metadata(required=true)
    private String name;
    @UriParam
    private boolean anyOrder;
    @UriParam(defaultValue="2000")
    private long timeout = 2000L;
    @UriParam
    private boolean split;
    @UriParam
    private String delimiter = "\\n|\\r";

    public TestEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    public void setExpectedMessageEndpoint(Endpoint expectedMessageEndpoint) {
        this.expectedMessageEndpoint = expectedMessageEndpoint;
    }

    protected void doStart() throws Exception {
        this.log.debug("Consuming expected messages from: {}", (Object)this.expectedMessageEndpoint);
        final ArrayList expectedBodies = new ArrayList();
        EndpointHelper.pollEndpoint((Endpoint)this.expectedMessageEndpoint, (Processor)new Processor(){

            public void process(Exchange exchange) throws Exception {
                Object body = TestEndpoint.this.getInBody(exchange);
                if (body instanceof WrappedFile) {
                    body = exchange.getIn().getBody(String.class);
                }
                if (TestEndpoint.this.split) {
                    Iterator it = ObjectHelper.createIterator((Object)body, (String)TestEndpoint.this.delimiter, (boolean)false, (boolean)true);
                    while (it.hasNext()) {
                        Object line = it.next();
                        TestEndpoint.this.log.trace("Received message body {}", line);
                        expectedBodies.add(line);
                    }
                } else {
                    expectedBodies.add(body);
                }
            }
        }, (long)this.timeout);
        this.log.info("Received: {} expected message(s) from: {}", (Object)expectedBodies.size(), (Object)this.expectedMessageEndpoint);
        if (this.anyOrder) {
            this.expectedBodiesReceivedInAnyOrder(expectedBodies);
        } else {
            this.expectedBodiesReceived(expectedBodies);
        }
    }

    protected Object getInBody(Exchange exchange) {
        return exchange.getIn().getBody();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean isAnyOrder() {
        return this.anyOrder;
    }

    public void setAnyOrder(boolean anyOrder) {
        this.anyOrder = anyOrder;
    }

    public boolean isSplit() {
        return this.split;
    }

    public void setSplit(boolean split) {
        this.split = split;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }
}

