/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.lang.annotation.Annotation;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.builder.xml.XPathBuilder;
import org.apache.camel.component.bean.DefaultAnnotationExpressionFactory;
import org.apache.camel.language.LanguageAnnotation;
import org.apache.camel.language.NamespacePrefix;
import org.apache.camel.util.ObjectHelper;

public class XPathAnnotationExpressionFactory
extends DefaultAnnotationExpressionFactory {
    @Override
    public Expression createExpression(CamelContext camelContext, Annotation annotation, LanguageAnnotation languageAnnotation, Class<?> expressionReturnType) {
        String headerName;
        String xpath = this.getExpressionFromAnnotation(annotation);
        Class<?> resultType = this.getResultType(annotation);
        if (resultType.equals(Object.class)) {
            resultType = expressionReturnType;
        }
        XPathBuilder builder = XPathBuilder.xpath(xpath, resultType);
        NamespacePrefix[] namespaces = this.getExpressionNameSpacePrefix(annotation);
        if (namespaces != null) {
            for (NamespacePrefix namespacePrefix : namespaces) {
                builder = builder.namespace(namespacePrefix.prefix(), namespacePrefix.uri());
            }
        }
        if (ObjectHelper.isNotEmpty((Object)(headerName = this.getHeaderName(annotation)))) {
            builder.setHeaderName(headerName);
        }
        return builder;
    }

    protected Class<?> getResultType(Annotation annotation) {
        return (Class)this.getAnnotationObjectValue(annotation, "resultType");
    }

    protected NamespacePrefix[] getExpressionNameSpacePrefix(Annotation annotation) {
        return (NamespacePrefix[])this.getAnnotationObjectValue(annotation, "namespaces");
    }

    protected String getHeaderName(Annotation annotation) {
        String headerValue = null;
        try {
            headerValue = (String)this.getAnnotationObjectValue(annotation, "headerName");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return headerValue;
    }
}

