/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.bean.MethodBean;
import org.apache.camel.impl.converter.ToStringTypeConverter;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanInvocation
implements Externalizable {
    private static final Logger LOG = LoggerFactory.getLogger(BeanInvocation.class);
    private Object[] args;
    private MethodBean methodBean;
    private transient Method method;

    public BeanInvocation() {
    }

    public BeanInvocation(Method method, Object[] args) {
        this.method = method;
        this.args = args;
    }

    public String toString() {
        List<Object> list = null;
        if (this.args != null) {
            list = Arrays.asList(this.args);
        }
        return "BeanInvocation " + this.method + " with " + list + "]";
    }

    public Object[] getArgs() {
        return this.args;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void setArgs(Object[] args) {
        this.args = args;
    }

    public void invoke(Object pojo, Exchange exchange) {
        try {
            Method method = this.getMethod();
            Object[] args = this.getArgs();
            LOG.trace("Invoking method: {} with args: {}", (Object)method, (Object)args);
            Object response = org.apache.camel.support.ObjectHelper.invokeMethodSafe((Method)method, (Object)pojo, (Object[])args);
            LOG.trace("Got response: {}", response);
            exchange.getOut().setBody(response);
        }
        catch (InvocationTargetException e) {
            exchange.setException((Throwable)RuntimeCamelException.wrapRuntimeCamelException((Throwable)e.getCause()));
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.methodBean = (MethodBean)ObjectHelper.cast(MethodBean.class, (Object)objectInput.readObject());
        try {
            this.method = this.methodBean.getMethod();
        }
        catch (NoSuchMethodException e) {
            throw new IOException(e);
        }
        this.args = (Object[])ObjectHelper.cast(Object[].class, (Object)objectInput.readObject());
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (this.methodBean == null) {
            this.methodBean = new MethodBean(this.method);
        }
        objectOutput.writeObject(this.methodBean);
        objectOutput.writeObject(this.args);
    }

    static {
        ToStringTypeConverter.registerMissType(BeanInvocation.class);
    }
}

