/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.bean.BeanInvocation;
import org.apache.camel.spi.TypeConverterRegistry;

@Converter(loader=true)
public final class BeanConverter {
    private BeanConverter() {
    }

    @Converter(fallback=true)
    public static Object convertTo(Class<?> type, Exchange exchange, Object value, TypeConverterRegistry registry) {
        if (BeanInvocation.class.isAssignableFrom(value.getClass())) {
            BeanInvocation bi = (BeanInvocation)value;
            if (bi.getArgs() == null || bi.getArgs().length != 1) {
                return TypeConverter.MISS_VALUE;
            }
            Class<?> from = bi.getArgs()[0].getClass();
            Object body = bi.getArgs()[0];
            if (type.isAssignableFrom(from)) {
                return body;
            }
            TypeConverter tc = registry.lookup(type, from);
            if (tc != null) {
                return tc.convertTo(type, exchange, body);
            }
        }
        return null;
    }
}

