/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ScriptHelper;
import org.apache.camel.language.simple.SimpleLanguage;

public class SimpleBuilder
implements Predicate,
Expression {
    private final String text;
    private Class<?> resultType;
    private volatile Expression expression;
    private volatile Predicate predicate;

    public SimpleBuilder(String text) {
        this.text = text;
    }

    public static SimpleBuilder simple(String text) {
        return new SimpleBuilder(text);
    }

    public static SimpleBuilder simple(String text, Class<?> resultType) {
        SimpleBuilder answer = SimpleBuilder.simple(text);
        answer.setResultType(resultType);
        return answer;
    }

    public static SimpleBuilder simpleF(String formatText, Object ... values) {
        return SimpleBuilder.simple(String.format(formatText, values));
    }

    public static SimpleBuilder simpleF(String formatText, Class<?> resultType, Object ... values) {
        return SimpleBuilder.simple(String.format(formatText, values), resultType);
    }

    public String getText() {
        return this.text;
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public void setResultType(Class<?> resultType) {
        this.resultType = resultType;
    }

    public SimpleBuilder resultType(Class<?> resultType) {
        this.setResultType(resultType);
        return this;
    }

    public boolean matches(Exchange exchange) {
        if (this.predicate == null) {
            this.predicate = this.createPredicate(exchange);
        }
        return this.predicate.matches(exchange);
    }

    public <T> T evaluate(Exchange exchange, Class<T> type) {
        if (this.expression == null) {
            this.expression = this.createExpression(exchange);
        }
        return (T)this.expression.evaluate(exchange, type);
    }

    private Predicate createPredicate(Exchange exchange) {
        SimpleLanguage simple = (SimpleLanguage)exchange.getContext().resolveLanguage("simple");
        try {
            String resolve = exchange.getContext().resolvePropertyPlaceholders(this.text);
            resolve = ScriptHelper.resolveOptionalExternalScript(exchange.getContext(), exchange, resolve);
            return simple.createPredicate(resolve);
        }
        catch (Exception e) {
            throw CamelExecutionException.wrapCamelExecutionException((Exchange)exchange, (Throwable)e);
        }
    }

    private Expression createExpression(Exchange exchange) {
        SimpleLanguage simple = (SimpleLanguage)exchange.getContext().resolveLanguage("simple");
        try {
            String resolve = exchange.getContext().resolvePropertyPlaceholders(this.text);
            resolve = ScriptHelper.resolveOptionalExternalScript(exchange.getContext(), exchange, resolve);
            return simple.createExpression(resolve, this.resultType);
        }
        catch (Exception e) {
            throw CamelExecutionException.wrapCamelExecutionException((Exchange)exchange, (Throwable)e);
        }
    }

    public String toString() {
        return "Simple: " + this.text;
    }
}

