/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.language.simple.SimpleLanguage;
import org.apache.camel.spi.Language;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;

public final class ScriptHelper {
    private ScriptHelper() {
    }

    public static String resolveOptionalExternalScript(CamelContext camelContext, String expression) {
        return ScriptHelper.resolveOptionalExternalScript(camelContext, null, expression);
    }

    public static String resolveOptionalExternalScript(CamelContext camelContext, Exchange exchange, String expression) {
        if (expression == null) {
            return null;
        }
        String external = expression;
        int newLines = StringHelper.countChar((String)expression, (char)'\n');
        if (newLines > 1) {
            return expression;
        }
        if (external.startsWith("resource:") && ResourceHelper.hasScheme((String)(external = external.substring(9)))) {
            if (exchange != null && SimpleLanguage.hasSimpleFunction(external)) {
                Language simple = exchange.getContext().resolveLanguage("simple");
                external = (String)simple.createExpression(external).evaluate(exchange, String.class);
            }
            InputStream is = null;
            try {
                is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)camelContext, (String)external);
                expression = (String)camelContext.getTypeConverter().convertTo(String.class, (Object)is);
            }
            catch (IOException e) {
                throw new RuntimeCamelException("Cannot load resource " + external, (Throwable)e);
            }
            finally {
                IOHelper.close((Closeable)is);
            }
        }
        return expression;
    }
}

