/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.xml.Namespaces;
import org.apache.camel.model.language.ConstantExpression;
import org.apache.camel.model.language.ExchangePropertyExpression;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.language.GroovyExpression;
import org.apache.camel.model.language.HeaderExpression;
import org.apache.camel.model.language.Hl7TerserExpression;
import org.apache.camel.model.language.JavaScriptExpression;
import org.apache.camel.model.language.JsonPathExpression;
import org.apache.camel.model.language.LanguageExpression;
import org.apache.camel.model.language.MethodCallExpression;
import org.apache.camel.model.language.MvelExpression;
import org.apache.camel.model.language.OgnlExpression;
import org.apache.camel.model.language.RefExpression;
import org.apache.camel.model.language.SimpleExpression;
import org.apache.camel.model.language.SpELExpression;
import org.apache.camel.model.language.TokenizerExpression;
import org.apache.camel.model.language.XMLTokenizerExpression;
import org.apache.camel.model.language.XPathExpression;
import org.apache.camel.model.language.XQueryExpression;

public class ExpressionClauseSupport<T> {
    private T result;
    private Expression expressionValue;
    private ExpressionDefinition expressionType;

    public ExpressionClauseSupport(T result) {
        this.result = result;
    }

    public T expression(Expression expression) {
        this.setExpressionValue(expression);
        return this.result;
    }

    public T expression(ExpressionDefinition expression) {
        this.setExpressionType(expression);
        return this.result;
    }

    public T constant(Object value) {
        if (value instanceof String) {
            return this.expression(new ConstantExpression((String)value));
        }
        return this.expression(ExpressionBuilder.constantExpression(value));
    }

    public T exchange() {
        return this.expression(ExpressionBuilder.exchangeExpression());
    }

    public T inMessage() {
        return this.expression(ExpressionBuilder.inMessageExpression());
    }

    public T outMessage() {
        return this.expression(ExpressionBuilder.outMessageExpression());
    }

    public T body() {
        return this.expression(new SimpleExpression("${body}"));
    }

    public T body(Class<?> expectedType) {
        return this.expression(ExpressionBuilder.bodyExpression(expectedType));
    }

    public T outBody() {
        return this.expression(ExpressionBuilder.outBodyExpression());
    }

    public T outBody(Class<?> expectedType) {
        return this.expression(ExpressionBuilder.outBodyExpression(expectedType));
    }

    public T header(String name) {
        return this.expression(new HeaderExpression(name));
    }

    public T headers() {
        return this.expression(ExpressionBuilder.headersExpression());
    }

    public T outHeader(String name) {
        return this.expression(ExpressionBuilder.outHeaderExpression(name));
    }

    public T outHeaders() {
        return this.expression(ExpressionBuilder.outHeadersExpression());
    }

    public T attachments() {
        return this.expression(ExpressionBuilder.attachmentObjectValuesExpression());
    }

    public T exchangePattern() {
        return this.expression(ExpressionBuilder.exchangePatternExpression());
    }

    public T exchangeProperty(String name) {
        return this.expression(new ExchangePropertyExpression(name));
    }

    public T exchangeProperties() {
        return this.expression(ExpressionBuilder.exchangePropertiesExpression());
    }

    public T method(String bean) {
        return this.expression(new MethodCallExpression(bean));
    }

    public T method(Object instance) {
        return this.expression(new MethodCallExpression(instance));
    }

    public T method(Class<?> beanType) {
        return this.expression(new MethodCallExpression(beanType));
    }

    public T method(String bean, String method) {
        return this.expression(new MethodCallExpression(bean, method));
    }

    public T method(Object instance, String method) {
        return this.expression(new MethodCallExpression(instance, method));
    }

    public T method(Class<?> beanType, String method) {
        return this.expression(new MethodCallExpression(beanType, method));
    }

    public T groovy(String text) {
        return this.expression(new GroovyExpression(text));
    }

    @Deprecated
    public T javaScript(String text) {
        return this.expression(new JavaScriptExpression(text));
    }

    public T jsonpath(String text) {
        return this.jsonpath(text, false);
    }

    public T jsonpath(String text, boolean suppressExceptions) {
        JsonPathExpression expression = new JsonPathExpression(text);
        expression.setSuppressExceptions(suppressExceptions);
        return this.expression(expression);
    }

    public T jsonpath(String text, boolean suppressExceptions, boolean allowSimple) {
        JsonPathExpression expression = new JsonPathExpression(text);
        expression.setSuppressExceptions(suppressExceptions);
        expression.setAllowSimple(allowSimple);
        return this.expression(expression);
    }

    public T jsonpath(String text, Class<?> resultType) {
        JsonPathExpression expression = new JsonPathExpression(text);
        expression.setResultType(resultType);
        this.setExpressionType(expression);
        return this.result;
    }

    public T jsonpath(String text, boolean suppressExceptions, Class<?> resultType) {
        JsonPathExpression expression = new JsonPathExpression(text);
        expression.setSuppressExceptions(suppressExceptions);
        expression.setResultType(resultType);
        this.setExpressionType(expression);
        return this.result;
    }

    public T jsonpath(String text, boolean suppressExceptions, boolean allowSimple, Class<?> resultType) {
        JsonPathExpression expression = new JsonPathExpression(text);
        expression.setSuppressExceptions(suppressExceptions);
        expression.setAllowSimple(allowSimple);
        expression.setResultType(resultType);
        this.setExpressionType(expression);
        return this.result;
    }

    public T jsonpath(String text, boolean suppressExceptions, boolean allowSimple, Class<?> resultType, String headerName) {
        JsonPathExpression expression = new JsonPathExpression(text);
        expression.setSuppressExceptions(suppressExceptions);
        expression.setAllowSimple(allowSimple);
        expression.setResultType(resultType);
        expression.setHeaderName(headerName);
        this.setExpressionType(expression);
        return this.result;
    }

    public T jsonpathWriteAsString(String text) {
        return this.jsonpathWriteAsString(text, false);
    }

    public T jsonpathWriteAsString(String text, boolean suppressExceptions) {
        JsonPathExpression expression = new JsonPathExpression(text);
        expression.setWriteAsString(true);
        expression.setSuppressExceptions(suppressExceptions);
        return this.expression(expression);
    }

    public T jsonpathWriteAsString(String text, boolean suppressExceptions, boolean allowSimple) {
        JsonPathExpression expression = new JsonPathExpression(text);
        expression.setWriteAsString(true);
        expression.setSuppressExceptions(suppressExceptions);
        expression.setAllowSimple(allowSimple);
        return this.expression(expression);
    }

    public T jsonpathWriteAsString(String text, boolean suppressExceptions, boolean allowSimple, String headerName) {
        JsonPathExpression expression = new JsonPathExpression(text);
        expression.setWriteAsString(true);
        expression.setSuppressExceptions(suppressExceptions);
        expression.setAllowSimple(allowSimple);
        expression.setHeaderName(headerName);
        return this.expression(expression);
    }

    public T ognl(String text) {
        return this.expression(new OgnlExpression(text));
    }

    public T mvel(String text) {
        return this.expression(new MvelExpression(text));
    }

    public T ref(String ref) {
        return this.expression(new RefExpression(ref));
    }

    public T spel(String text) {
        return this.expression(new SpELExpression(text));
    }

    public T simple(String text) {
        return this.expression(new SimpleExpression(text));
    }

    public T simple(String text, Class<?> resultType) {
        SimpleExpression expression = new SimpleExpression(text);
        expression.setResultType(resultType);
        this.setExpressionType(expression);
        return this.result;
    }

    public T hl7terser(String text) {
        return this.expression(new Hl7TerserExpression(text));
    }

    public T tokenize(String token) {
        return this.tokenize(token, null, false);
    }

    public T tokenize(String token, int group) {
        return this.tokenize(token, null, false, group);
    }

    public T tokenize(String token, int group, boolean skipFirst) {
        return this.tokenize(token, null, false, group, skipFirst);
    }

    public T tokenize(String token, boolean regex) {
        return this.tokenize(token, null, regex);
    }

    public T tokenize(String token, boolean regex, int group) {
        return this.tokenize(token, null, regex, group);
    }

    public T tokenize(String token, String headerName) {
        return this.tokenize(token, headerName, false);
    }

    public T tokenize(String token, String headerName, boolean regex) {
        TokenizerExpression expression = new TokenizerExpression();
        expression.setToken(token);
        expression.setHeaderName(headerName);
        expression.setRegex(regex);
        this.setExpressionType(expression);
        return this.result;
    }

    public T tokenize(String token, String headerName, boolean regex, int group) {
        return this.tokenize(token, headerName, regex, group, false);
    }

    public T tokenize(String token, String headerName, boolean regex, boolean skipFirst) {
        TokenizerExpression expression = new TokenizerExpression();
        expression.setToken(token);
        expression.setHeaderName(headerName);
        expression.setRegex(regex);
        expression.setSkipFirst(skipFirst);
        this.setExpressionType(expression);
        return this.result;
    }

    public T tokenize(String token, String headerName, boolean regex, int group, boolean skipFirst) {
        return this.tokenize(token, headerName, regex, "" + group, skipFirst);
    }

    public T tokenize(String token, String headerName, boolean regex, String group, boolean skipFirst) {
        TokenizerExpression expression = new TokenizerExpression();
        expression.setToken(token);
        expression.setHeaderName(headerName);
        expression.setRegex(regex);
        expression.setGroup(group);
        expression.setSkipFirst(skipFirst);
        this.setExpressionType(expression);
        return this.result;
    }

    public T tokenizePair(String startToken, String endToken, boolean includeTokens) {
        TokenizerExpression expression = new TokenizerExpression();
        expression.setToken(startToken);
        expression.setEndToken(endToken);
        expression.setIncludeTokens(includeTokens);
        this.setExpressionType(expression);
        return this.result;
    }

    public T tokenizeXMLPair(String tagName, String inheritNamespaceTagName, int group) {
        return this.tokenizeXMLPair(tagName, inheritNamespaceTagName, "" + group);
    }

    public T tokenizeXMLPair(String tagName, String inheritNamespaceTagName, String group) {
        TokenizerExpression expression = new TokenizerExpression();
        expression.setToken(tagName);
        expression.setInheritNamespaceTagName(inheritNamespaceTagName);
        expression.setXml(true);
        expression.setGroup(group);
        this.setExpressionType(expression);
        return this.result;
    }

    public T xtokenize(String path, char mode, Namespaces namespaces, int group) {
        XMLTokenizerExpression expression = new XMLTokenizerExpression(path);
        expression.setMode(Character.toString(mode));
        expression.setNamespaces(namespaces.getNamespaces());
        if (group > 0) {
            expression.setGroup(group);
        }
        this.setExpressionType(expression);
        return this.result;
    }

    public T xpath(String text) {
        return this.expression(new XPathExpression(text));
    }

    public T xpath(String text, String headerName) {
        XPathExpression expression = new XPathExpression(text);
        expression.setHeaderName(headerName);
        return this.expression(expression);
    }

    public T xpath(String text, Class<?> resultType) {
        XPathExpression expression = new XPathExpression(text);
        expression.setResultType(resultType);
        this.setExpressionType(expression);
        return this.result;
    }

    public T xpath(String text, Class<?> resultType, String headerName) {
        XPathExpression expression = new XPathExpression(text);
        expression.setHeaderName(headerName);
        this.setExpressionType(expression);
        return this.result;
    }

    public T xpath(String text, Class<?> resultType, Namespaces namespaces) {
        return this.xpath(text, resultType, namespaces.getNamespaces());
    }

    public T xpath(String text, Class<?> resultType, Namespaces namespaces, String headerName) {
        XPathExpression expression = new XPathExpression(text);
        expression.setResultType(resultType);
        expression.setNamespaces(namespaces.getNamespaces());
        expression.setHeaderName(headerName);
        this.setExpressionType(expression);
        return this.result;
    }

    public T xpath(String text, Class<?> resultType, Map<String, String> namespaces) {
        XPathExpression expression = new XPathExpression(text);
        expression.setResultType(resultType);
        expression.setNamespaces(namespaces);
        this.setExpressionType(expression);
        return this.result;
    }

    public T xpath(String text, Namespaces namespaces) {
        return this.xpath(text, namespaces.getNamespaces());
    }

    public T xpath(String text, Map<String, String> namespaces) {
        XPathExpression expression = new XPathExpression(text);
        expression.setNamespaces(namespaces);
        this.setExpressionType(expression);
        return this.result;
    }

    public T xquery(String text) {
        return this.expression(new XQueryExpression(text));
    }

    public T xquery(String text, String headerName) {
        XQueryExpression expression = new XQueryExpression(text);
        expression.setHeaderName(headerName);
        return this.expression(expression);
    }

    public T xquery(String text, Class<?> resultType) {
        XQueryExpression expression = new XQueryExpression(text);
        expression.setResultType(resultType);
        this.setExpressionType(expression);
        return this.result;
    }

    public T xquery(String text, Class<?> resultType, String headerName) {
        XQueryExpression expression = new XQueryExpression(text);
        expression.setHeaderName(headerName);
        this.setExpressionType(expression);
        return this.result;
    }

    public T xquery(String text, Class<?> resultType, Namespaces namespaces) {
        return this.xquery(text, resultType, namespaces.getNamespaces());
    }

    public T xquery(String text, Class<?> resultType, Namespaces namespaces, String headerName) {
        XQueryExpression expression = new XQueryExpression(text);
        expression.setResultType(resultType);
        expression.setNamespaces(namespaces.getNamespaces());
        expression.setHeaderName(headerName);
        this.setExpressionType(expression);
        return this.result;
    }

    public T xquery(String text, Class<?> resultType, Map<String, String> namespaces) {
        XQueryExpression expression = new XQueryExpression(text);
        expression.setResultType(resultType);
        expression.setNamespaces(namespaces);
        this.setExpressionType(expression);
        return this.result;
    }

    public T xquery(String text, Namespaces namespaces) {
        return this.xquery(text, namespaces.getNamespaces());
    }

    public T xquery(String text, Map<String, String> namespaces) {
        XQueryExpression expression = new XQueryExpression(text);
        expression.setNamespaces(namespaces);
        this.setExpressionType(expression);
        return this.result;
    }

    public T language(String language, String expression) {
        LanguageExpression exp = new LanguageExpression(language, expression);
        this.setExpressionType(exp);
        return this.result;
    }

    public Expression getExpressionValue() {
        return this.expressionValue;
    }

    public void setExpressionValue(Expression expressionValue) {
        this.expressionValue = expressionValue;
    }

    public ExpressionDefinition getExpressionType() {
        return this.expressionType;
    }

    public void setExpressionType(ExpressionDefinition expressionType) {
        this.expressionType = expressionType;
    }

    protected Expression createExpression(CamelContext camelContext) {
        if (this.getExpressionValue() == null) {
            if (this.getExpressionType() != null) {
                this.setExpressionValue(this.getExpressionType().createExpression(camelContext));
            } else {
                throw new IllegalStateException("No expression value configured");
            }
        }
        return this.getExpressionValue();
    }

    protected void configureExpression(CamelContext camelContext, Expression expression) {
    }
}

