/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.BinaryPredicate;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.util.ObjectHelper;

public abstract class BinaryPredicateSupport
implements BinaryPredicate {
    private final Expression left;
    private final Expression right;

    protected BinaryPredicateSupport(Expression left, Expression right) {
        ObjectHelper.notNull((Object)left, (String)"left");
        ObjectHelper.notNull((Object)right, (String)"right");
        this.left = left;
        this.right = right;
    }

    public String toString() {
        return this.left + " " + this.getOperationText() + " " + this.right;
    }

    public boolean matches(Exchange exchange) {
        return this.matchesReturningFailureMessage(exchange) == null;
    }

    public String matchesReturningFailureMessage(Exchange exchange) {
        Object rightValue;
        String answer = null;
        Object leftValue = this.left.evaluate(exchange, Object.class);
        if (!this.matches(exchange, leftValue, rightValue = this.right.evaluate(exchange, Object.class))) {
            answer = leftValue + " " + this.getOperator() + " " + rightValue;
        }
        return answer;
    }

    protected abstract boolean matches(Exchange var1, Object var2, Object var3);

    protected abstract String getOperationText();

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    public String getOperator() {
        return this.getOperationText();
    }
}

