/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.EncryptionMaterials;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.aws.s3.S3Operations;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.util.ObjectHelper;

@UriParams
public class S3Configuration
implements Cloneable {
    private String bucketName;
    @UriParam
    private AmazonS3 amazonS3Client;
    @UriParam(label="security", secret=true)
    private String accessKey;
    @UriParam(label="security", secret=true)
    private String secretKey;
    @UriParam(label="consumer")
    private String fileName;
    @UriParam(label="consumer")
    private String prefix;
    @UriParam
    private String region;
    @UriParam(label="consumer", defaultValue="true")
    private boolean deleteAfterRead = true;
    @UriParam(label="producer")
    private boolean deleteAfterWrite;
    @UriParam(label="producer")
    private boolean multiPartUpload;
    @UriParam(label="producer", defaultValue="26214400")
    private long partSize = 0x1900000L;
    @UriParam
    private String policy;
    @UriParam(label="producer")
    private String storageClass;
    @UriParam(label="producer")
    private String serverSideEncryption;
    @UriParam
    private String proxyHost;
    @UriParam
    private Integer proxyPort;
    @UriParam(label="consumer", defaultValue="true")
    private boolean includeBody = true;
    @UriParam
    private boolean pathStyleAccess;
    @UriParam(label="producer", enums="copyObject,deleteBucket,listBuckets,downloadLink")
    private S3Operations operation;
    @UriParam(label="consumer,advanced", defaultValue="true")
    private boolean autocloseBody = true;
    @UriParam(label="common,advanced")
    private EncryptionMaterials encryptionMaterials;
    @UriParam(label="common,advanced", defaultValue="false")
    private boolean useEncryption;
    @UriParam(label="common, advanced", defaultValue="false")
    private boolean chunkedEncodingDisabled;
    @UriParam(label="common, advanced", defaultValue="false")
    private boolean accelerateModeEnabled;
    @UriParam(label="common, advanced", defaultValue="false")
    private boolean dualstackEnabled;
    @UriParam(label="common, advanced", defaultValue="false")
    private boolean payloadSigningEnabled;
    @UriParam(label="common, advanced", defaultValue="false")
    private boolean forceGlobalBucketAccessEnabled;
    @UriParam(label="producer,advanced", defaultValue="false")
    private boolean useAwsKMS;
    @UriParam(label="producer,advanced")
    private String awsKMSKeyId;
    @UriParam(defaultValue="false")
    private boolean useIAMCredentials;

    public long getPartSize() {
        return this.partSize;
    }

    public void setPartSize(long partSize) {
        this.partSize = partSize;
    }

    public boolean isMultiPartUpload() {
        return this.multiPartUpload;
    }

    public void setMultiPartUpload(boolean multiPartUpload) {
        this.multiPartUpload = multiPartUpload;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public AmazonS3 getAmazonS3Client() {
        return this.amazonS3Client;
    }

    public void setAmazonS3Client(AmazonS3 amazonS3Client) {
        this.amazonS3Client = amazonS3Client;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setIncludeBody(boolean includeBody) {
        this.includeBody = includeBody;
    }

    public boolean isIncludeBody() {
        return this.includeBody;
    }

    public boolean isDeleteAfterRead() {
        return this.deleteAfterRead;
    }

    public void setDeleteAfterRead(boolean deleteAfterRead) {
        this.deleteAfterRead = deleteAfterRead;
    }

    public boolean isDeleteAfterWrite() {
        return this.deleteAfterWrite;
    }

    public void setDeleteAfterWrite(boolean deleteAfterWrite) {
        this.deleteAfterWrite = deleteAfterWrite;
    }

    public String getPolicy() {
        return this.policy;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(String storageClass) {
        this.storageClass = storageClass;
    }

    public String getServerSideEncryption() {
        return this.serverSideEncryption;
    }

    public void setServerSideEncryption(String serverSideEncryption) {
        this.serverSideEncryption = serverSideEncryption;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setPathStyleAccess(boolean pathStyleAccess) {
        this.pathStyleAccess = pathStyleAccess;
    }

    public boolean isPathStyleAccess() {
        return this.pathStyleAccess;
    }

    public S3Operations getOperation() {
        return this.operation;
    }

    public void setOperation(S3Operations operation) {
        this.operation = operation;
    }

    public boolean isAutocloseBody() {
        return this.autocloseBody;
    }

    public void setAutocloseBody(boolean autocloseBody) {
        this.autocloseBody = autocloseBody;
    }

    public EncryptionMaterials getEncryptionMaterials() {
        return this.encryptionMaterials;
    }

    public void setEncryptionMaterials(EncryptionMaterials encryptionMaterials) {
        this.encryptionMaterials = encryptionMaterials;
    }

    public boolean isUseEncryption() {
        return this.useEncryption;
    }

    public void setUseEncryption(boolean useEncryption) {
        this.useEncryption = useEncryption;
    }

    public boolean isUseAwsKMS() {
        return this.useAwsKMS;
    }

    public void setUseAwsKMS(boolean useAwsKMS) {
        this.useAwsKMS = useAwsKMS;
    }

    public String getAwsKMSKeyId() {
        return this.awsKMSKeyId;
    }

    public void setAwsKMSKeyId(String awsKMSKeyId) {
        this.awsKMSKeyId = awsKMSKeyId;
    }

    public boolean isChunkedEncodingDisabled() {
        return this.chunkedEncodingDisabled;
    }

    public void setChunkedEncodingDisabled(boolean chunkedEncodingDisabled) {
        this.chunkedEncodingDisabled = chunkedEncodingDisabled;
    }

    public boolean isAccelerateModeEnabled() {
        return this.accelerateModeEnabled;
    }

    public void setAccelerateModeEnabled(boolean accelerateModeEnabled) {
        this.accelerateModeEnabled = accelerateModeEnabled;
    }

    public boolean isDualstackEnabled() {
        return this.dualstackEnabled;
    }

    public void setDualstackEnabled(boolean dualstackEnabled) {
        this.dualstackEnabled = dualstackEnabled;
    }

    public boolean isPayloadSigningEnabled() {
        return this.payloadSigningEnabled;
    }

    public void setPayloadSigningEnabled(boolean payloadSigningEnabled) {
        this.payloadSigningEnabled = payloadSigningEnabled;
    }

    public boolean isForceGlobalBucketAccessEnabled() {
        return this.forceGlobalBucketAccessEnabled;
    }

    public void setForceGlobalBucketAccessEnabled(boolean forceGlobalBucketAccessEnabled) {
        this.forceGlobalBucketAccessEnabled = forceGlobalBucketAccessEnabled;
    }

    public void setUseIAMCredentials(Boolean useIAMCredentials) {
        this.useIAMCredentials = useIAMCredentials;
    }

    public Boolean isUseIAMCredentials() {
        return this.useIAMCredentials;
    }

    public boolean hasProxyConfiguration() {
        return ObjectHelper.isNotEmpty((Object)this.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.getProxyPort());
    }

    public S3Configuration copy() {
        try {
            return (S3Configuration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

