/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stax;

import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.camel.support.LRUSoftCache;

public final class StAXUtil {
    private static final Map<Class<?>, String> TAG_NAMES = new LRUSoftCache(1000);

    private StAXUtil() {
    }

    public static String getTagName(Class<?> handled) {
        if (TAG_NAMES.containsKey(handled)) {
            return TAG_NAMES.get(handled);
        }
        XmlType xmlType = handled.getAnnotation(XmlType.class);
        if (xmlType != null && xmlType.name() != null && xmlType.name().trim().length() > 0) {
            TAG_NAMES.put(handled, xmlType.name());
            return xmlType.name();
        }
        XmlRootElement xmlRoot = handled.getAnnotation(XmlRootElement.class);
        if (xmlRoot != null && xmlRoot.name() != null && xmlRoot.name().trim().length() > 0) {
            TAG_NAMES.put(handled, xmlRoot.name());
            return xmlRoot.name();
        }
        throw new IllegalArgumentException("XML name not found for " + handled.getName());
    }
}

