/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.linkedin.api;

import java.io.IOException;
import java.util.Map;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.camel.component.linkedin.api.LinkedInException;
import org.apache.camel.component.linkedin.api.model.Error;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=5000)
public class LinkedInExceptionResponseFilter
implements ClientResponseFilter {
    private static final Logger LOG = LoggerFactory.getLogger(LinkedInExceptionResponseFilter.class);
    private final JAXBContext jaxbContext;

    public LinkedInExceptionResponseFilter() {
        try {
            this.jaxbContext = JAXBContext.newInstance((String)Error.class.getPackage().getName());
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("Error initializing JAXB: " + e.getMessage(), e);
        }
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        if (responseContext.getStatus() != Response.Status.OK.getStatusCode() && responseContext.hasEntity()) {
            try {
                Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
                Error error = (Error)unmarshaller.unmarshal(responseContext.getEntityStream());
                Response.ResponseBuilder builder = Response.status((Response.StatusType)responseContext.getStatusInfo());
                builder.entity((Object)error);
                for (Map.Entry header : responseContext.getHeaders().entrySet()) {
                    builder.header((String)header.getKey(), header.getValue());
                }
                throw new LinkedInException(error, builder.build());
            }
            catch (JAXBException e) {
                LOG.warn("Unable to parse LinkedIn error: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }
}

