/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rss;

import com.sun.syndication.feed.synd.SyndEntry;
import java.util.Date;
import java.util.Map;
import org.apache.camel.component.feed.EntryFilter;
import org.apache.camel.component.feed.FeedEndpoint;
import org.apache.camel.support.LRUCacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdatedDateFilter
implements EntryFilter {
    private static final Logger LOG = LoggerFactory.getLogger(UpdatedDateFilter.class);
    private Date lastUpdate;
    private Map<Integer, Integer> entriesForLastUpdate = LRUCacheFactory.newLRUCache((int)1000);

    public UpdatedDateFilter(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public boolean isValidEntry(FeedEndpoint endpoint, Object feed, Object entry) {
        Date updated = ((SyndEntry)entry).getUpdatedDate();
        if (updated == null) {
            updated = ((SyndEntry)entry).getPublishedDate();
        }
        if (updated == null) {
            LOG.debug("No updated time for entry so assuming its valid: entry=[{}]", entry);
            return true;
        }
        if (this.lastUpdate != null) {
            if (this.lastUpdate.after(updated)) {
                LOG.debug("Entry is older than lastupdate=[{}], no valid entry=[{}]", (Object)this.lastUpdate, entry);
                return false;
            }
            Integer hash = entry.hashCode();
            if (this.lastUpdate.equals(updated)) {
                if (this.entriesForLastUpdate.containsKey(hash)) {
                    LOG.debug("Already processed entry=[{}]", entry);
                    return false;
                }
            } else {
                this.entriesForLastUpdate.clear();
            }
            this.entriesForLastUpdate.put(hash, hash);
        }
        this.lastUpdate = updated;
        return true;
    }
}

