/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4.http;

import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMethod;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.netty4.http.NettyHttpEndpoint;
import org.apache.camel.component.netty4.http.NettyHttpOperationFailedException;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;

public final class NettyHttpHelper {
    private NettyHttpHelper() {
    }

    public static void setCharsetFromContentType(String contentType, Exchange exchange) {
        String charset = NettyHttpHelper.getCharsetFromContentType(contentType);
        if (charset != null) {
            exchange.setProperty("CamelCharsetName", (Object)IOHelper.normalizeCharset((String)charset));
        }
    }

    public static String getCharsetFromContentType(String contentType) {
        int index;
        if (contentType != null && (index = contentType.indexOf("charset=")) > 0) {
            String charset = contentType.substring(index + 8);
            if (charset.contains(";")) {
                charset = StringHelper.before((String)charset, (String)";");
            }
            return IOHelper.normalizeCharset((String)charset);
        }
        return null;
    }

    public static void appendHeader(Map<String, Object> headers, String key, Object value) {
        if (headers.containsKey(key)) {
            ArrayList<Object> list;
            Object existing = headers.get(key);
            if (existing instanceof List) {
                list = (ArrayList<Object>)existing;
            } else {
                list = new ArrayList<Object>();
                list.add(existing);
            }
            list.add(value);
            value = list;
        }
        headers.put(key, value);
    }

    public static HttpMethod createMethod(Message message, boolean hasPayload) {
        HttpMethod m = (HttpMethod)message.getHeader("CamelHttpMethod", HttpMethod.class);
        if (m != null) {
            return m;
        }
        String name = (String)message.getHeader("CamelHttpMethod", String.class);
        if (name != null) {
            name = name.toUpperCase();
            return HttpMethod.valueOf((String)name);
        }
        if (hasPayload) {
            return HttpMethod.POST;
        }
        return HttpMethod.GET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Exception populateNettyHttpOperationFailedException(Exchange exchange, String url, FullHttpResponse response, int responseCode, boolean transferException) {
        InputStream is;
        String contentType;
        String uri = url;
        String statusText = response.status().reasonPhrase();
        if (responseCode >= 300 && responseCode < 400) {
            String redirectLocation = response.headers().get("location");
            if (redirectLocation != null) {
                return new NettyHttpOperationFailedException(uri, responseCode, statusText, redirectLocation, (HttpContent)response);
            }
            return new NettyHttpOperationFailedException(uri, responseCode, statusText, null, (HttpContent)response);
        }
        if (transferException && "application/x-java-serialized-object".equals(contentType = response.headers().get("Content-Type")) && (is = (InputStream)exchange.getContext().getTypeConverter().convertTo(InputStream.class, (Object)response)) != null) {
            try {
                Object body = NettyHttpHelper.deserializeJavaObjectFromStream(is);
                if (body instanceof Exception) {
                    Exception exception = (Exception)body;
                    return exception;
                }
            }
            catch (Exception e) {
                Exception exception = e;
                return exception;
            }
            finally {
                IOHelper.close((Closeable)is);
            }
        }
        return new NettyHttpOperationFailedException(uri, responseCode, statusText, null, (HttpContent)response);
    }

    public static Object deserializeJavaObjectFromStream(InputStream is) throws ClassNotFoundException, IOException {
        if (is == null) {
            return null;
        }
        Object answer = null;
        ObjectInputStream ois = new ObjectInputStream(is);
        try {
            answer = ois.readObject();
        }
        finally {
            IOHelper.close((Closeable)ois);
        }
        return answer;
    }

    public static String createURL(Exchange exchange, NettyHttpEndpoint endpoint) throws URISyntaxException {
        String uri = (String)exchange.getIn().removeHeader("CamelRestHttpUri");
        if (uri == null) {
            uri = endpoint.getEndpointUri();
        }
        try {
            uri = exchange.getContext().resolvePropertyPlaceholders(uri);
        }
        catch (Exception e) {
            throw new RuntimeExchangeException("Cannot resolve property placeholders with uri: " + uri, exchange, (Throwable)e);
        }
        String path = (String)exchange.getIn().getHeader("CamelHttpPath", String.class);
        if (path != null) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.length() > 0) {
                int idx = uri.indexOf("?");
                if (idx == -1) {
                    uri = uri.endsWith("/") ? uri : uri + "/";
                    uri = uri.concat(path);
                } else {
                    String base = uri.substring(0, idx);
                    base = base.endsWith("/") ? base : base + "/";
                    base = base.concat(path);
                    uri = base.concat(uri.substring(idx));
                }
            }
        }
        uri = UnsafeUriCharactersEncoder.encodeHttpURI((String)uri);
        return uri;
    }

    public static URI createURI(Exchange exchange, String url, NettyHttpEndpoint endpoint) throws URISyntaxException {
        URI uri = new URI(url);
        String queryString = (String)exchange.getIn().removeHeader("CamelRestHttpQuery");
        if (queryString == null) {
            queryString = (String)exchange.getIn().getHeader("CamelHttpRawQuery", String.class);
        }
        if (queryString == null) {
            queryString = (String)exchange.getIn().getHeader("CamelHttpQuery", String.class);
        }
        if (queryString == null) {
            queryString = uri.getRawQuery();
        }
        if (queryString != null) {
            queryString = UnsafeUriCharactersEncoder.encodeHttpURI((String)queryString);
            uri = URISupport.createURIWithQuery((URI)uri, (String)queryString);
        }
        return uri;
    }

    public static boolean isStatusCodeOk(int statusCode, String okStatusCodeRange) {
        String[] ranges;
        for (String range : ranges = okStatusCodeRange.split(",")) {
            boolean ok;
            if (range.contains("-")) {
                int from = Integer.valueOf(StringHelper.before((String)range, (String)"-"));
                int to = Integer.valueOf(StringHelper.after((String)range, (String)"-"));
                ok = statusCode >= from && statusCode <= to;
            } else {
                int exact = Integer.valueOf(range);
                boolean bl = ok = exact == statusCode;
            }
            if (!ok) continue;
            return true;
        }
        return false;
    }
}

