/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4.http;

import io.netty.handler.codec.http.FullHttpResponse;
import java.io.InputStream;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.netty4.http.NettyHttpConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.TypeConverterSupport;
import org.apache.camel.util.DoubleMap;

public class NettyHttpConverterLoader
implements TypeConverterLoader {
    private final DoubleMap<Class<?>, Class<?>, BaseTypeConverter> converters = new DoubleMap(3);

    private void registerConverters() {
        this.converters.put(byte[].class, FullHttpResponse.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return NettyHttpConverter.toBytes((FullHttpResponse)value, exchange);
            }
        });
        this.converters.put(InputStream.class, FullHttpResponse.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return NettyHttpConverter.toInputStream((FullHttpResponse)value, exchange);
            }
        });
        this.converters.put(String.class, FullHttpResponse.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return NettyHttpConverter.toString((FullHttpResponse)value, exchange);
            }
        });
    }

    public void load(final TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters();
        this.converters.forEach((k, v, c) -> registry.addTypeConverter(k, v, (TypeConverter)c));
        registry.addFallbackTypeConverter((TypeConverter)new TypeConverterSupport(){

            public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
                try {
                    return (T)NettyHttpConverter.convertToHttpRequest(type, exchange, value, registry);
                }
                catch (TypeConversionException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new TypeConversionException(value, type, (Throwable)e);
                }
            }
        }, false);
        registry.addFallbackTypeConverter((TypeConverter)new TypeConverterSupport(){

            public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
                try {
                    return (T)NettyHttpConverter.convertToHttpResponse(type, exchange, value, registry);
                }
                catch (TypeConversionException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new TypeConversionException(value, type, (Throwable)e);
                }
            }
        }, false);
    }

    static abstract class BaseTypeConverter
    extends TypeConverterSupport {
        private final boolean allowNull;

        public BaseTypeConverter(boolean allowNull) {
            this.allowNull = allowNull;
        }

        public boolean allowNull() {
            return this.allowNull;
        }

        public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
            try {
                return (T)this.doConvert(exchange, value);
            }
            catch (TypeConversionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TypeConversionException(value, type, (Throwable)e);
            }
        }

        protected abstract Object doConvert(Exchange var1, Object var2) throws Exception;
    }
}

