/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.websocket.jsr356;

import java.net.URI;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpointConfig;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.websocket.jsr356.CamelServerEndpoint;
import org.apache.camel.websocket.jsr356.ClientSessions;
import org.apache.camel.websocket.jsr356.JSR356Endpoint;
import org.apache.camel.websocket.jsr356.JSR356WebSocketComponent;

public class JSR356Consumer
extends DefaultConsumer {
    private final int sessionCount;
    private final String context;
    private ClientSessions manager;
    private Runnable closeTask;
    private final BiConsumer<Session, Object> onMessage = (session, message) -> {
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.getIn().setHeader("jsr356.session", session);
        exchange.getIn().setBody(message);
        this.getAsyncProcessor().process(exchange, doneSync -> {
            if (exchange.getException() != null) {
                this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
            }
        });
    };

    JSR356Consumer(JSR356Endpoint jsr356Endpoint, Processor processor, int sessionCount, String context) {
        super((Endpoint)jsr356Endpoint, processor);
        this.sessionCount = sessionCount;
        this.context = context;
    }

    public JSR356Endpoint getEndpoint() {
        return (JSR356Endpoint)((Object)JSR356Endpoint.class.cast(super.getEndpoint()));
    }

    protected void doStart() throws Exception {
        super.doStart();
        String endpointKey = this.getEndpoint().getEndpointUri().substring("websocket-jsr356://".length());
        if (endpointKey.contains("://")) {
            ClientEndpointConfig.Builder clientConfig = ClientEndpointConfig.Builder.create();
            this.manager = new ClientSessions(this.sessionCount, URI.create(endpointKey), clientConfig.build(), this.onMessage);
            this.manager.prepare();
        } else {
            JSR356WebSocketComponent.ContextBag bag = JSR356WebSocketComponent.getContext(this.context);
            CamelServerEndpoint endpoint = bag.getEndpoints().get(endpointKey);
            if (endpoint == null) {
                ServerEndpointConfig.Builder configBuilder = ServerEndpointConfig.Builder.create(CamelServerEndpoint.class, (String)endpointKey);
                final CamelServerEndpoint serverEndpoint = new CamelServerEndpoint();
                bag.getEndpoints().put(endpointKey, serverEndpoint);
                this.closeTask = this.addObserver(serverEndpoint);
                configBuilder.configurator(new ServerEndpointConfig.Configurator(){

                    public <T> T getEndpointInstance(Class<T> clazz) {
                        return clazz.cast((Object)serverEndpoint);
                    }
                });
                bag.getContainer().addEndpoint(configBuilder.build());
            } else {
                this.closeTask = this.addObserver(endpoint);
            }
        }
    }

    private Runnable addObserver(CamelServerEndpoint endpoint) {
        endpoint.getEndpoints().add(this.onMessage);
        return () -> endpoint.getEndpoints().remove(this.onMessage);
    }

    protected void doStop() throws Exception {
        Optional.ofNullable(this.manager).ifPresent(ClientSessions::close);
        Optional.ofNullable(this.closeTask).ifPresent(Runnable::run);
        super.doStop();
    }
}

