/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb3.converters;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.mongodb3.converters.MongoDbBasicConverters;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.TypeConverterSupport;
import org.apache.camel.util.DoubleMap;
import org.bson.Document;

public class MongoDbBasicConvertersLoader
implements TypeConverterLoader {
    private final DoubleMap<Class<?>, Class<?>, BaseTypeConverter> converters = new DoubleMap(6);

    private void registerConverters() {
        this.converters.put(List.class, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return MongoDbBasicConverters.fromStringToList((String)value);
            }
        });
        this.converters.put(Map.class, Document.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return MongoDbBasicConverters.fromDocumentToMap((Document)value);
            }
        });
        this.converters.put(Document.class, File.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return MongoDbBasicConverters.fromFileToDocument((File)value, exchange);
            }
        });
        this.converters.put(Document.class, InputStream.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return MongoDbBasicConverters.fromInputStreamToDocument((InputStream)value, exchange);
            }
        });
        this.converters.put(Document.class, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return MongoDbBasicConverters.fromStringToDocument((String)value);
            }
        });
        this.converters.put(Document.class, Map.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return MongoDbBasicConverters.fromMapToDocument((Map)value);
            }
        });
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters();
        this.converters.forEach((k, v, c) -> registry.addTypeConverter(k, v, (TypeConverter)c));
    }

    static abstract class BaseTypeConverter
    extends TypeConverterSupport {
        private final boolean allowNull;

        public BaseTypeConverter(boolean allowNull) {
            this.allowNull = allowNull;
        }

        public boolean allowNull() {
            return this.allowNull;
        }

        public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
            try {
                return (T)this.doConvert(exchange, value);
            }
            catch (TypeConversionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TypeConversionException(value, type, (Throwable)e);
            }
        }

        protected abstract Object doConvert(Exchange var1, Object var2) throws Exception;
    }
}

