/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb3;

import com.mongodb.CursorType;
import com.mongodb.MongoCursorNotFoundException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import java.util.concurrent.CountDownLatch;
import org.apache.camel.Exchange;
import org.apache.camel.component.mongodb3.CamelMongoDbException;
import org.apache.camel.component.mongodb3.MongoDbEndpoint;
import org.apache.camel.component.mongodb3.MongoDbTailTrackingManager;
import org.apache.camel.component.mongodb3.MongoDbTailableCursorConsumer;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbTailingProcess
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbTailingProcess.class);
    private static final String CAPPED_KEY = "capped";
    public volatile boolean keepRunning = true;
    public volatile boolean stopped;
    private volatile CountDownLatch stoppedLatch;
    private final MongoCollection<Document> dbCol;
    private final MongoDbEndpoint endpoint;
    private final MongoDbTailableCursorConsumer consumer;
    private final long cursorRegenerationDelay;
    private final boolean cursorRegenerationDelayEnabled;
    private MongoCursor<Document> cursor;
    private MongoDbTailTrackingManager tailTracking;

    public MongoDbTailingProcess(MongoDbEndpoint endpoint, MongoDbTailableCursorConsumer consumer, MongoDbTailTrackingManager tailTrack) {
        this.endpoint = endpoint;
        this.consumer = consumer;
        this.dbCol = endpoint.getMongoCollection();
        this.tailTracking = tailTrack;
        this.cursorRegenerationDelay = endpoint.getCursorRegenerationDelay();
        this.cursorRegenerationDelayEnabled = this.cursorRegenerationDelay != 0L;
    }

    public MongoCursor<Document> getCursor() {
        return this.cursor;
    }

    public void initializeProcess() throws Exception {
        if (LOG.isInfoEnabled()) {
            LOG.info("Starting MongoDB Tailable Cursor consumer, binding to collection: {}", (Object)("db: " + this.endpoint.getMongoDatabase() + ", col: " + this.endpoint.getCollection()));
        }
        if (!this.isCollectionCapped().booleanValue()) {
            throw new CamelMongoDbException("Tailable cursors are only compatible with capped collections, and collection " + this.endpoint.getCollection() + " is not capped");
        }
        try {
            this.tailTracking.recoverFromStore();
            this.cursor = this.initializeCursor();
        }
        catch (Exception e) {
            throw new CamelMongoDbException("Exception occurred while initializing tailable cursor", e);
        }
        if (this.cursor == null) {
            throw new CamelMongoDbException("Tailable cursor was not initialized, or cursor returned is dead on arrival");
        }
    }

    private Boolean isCollectionCapped() {
        return this.endpoint.getMongoDatabase().runCommand((Bson)this.createCollStatsCommand()).getBoolean((Object)CAPPED_KEY);
    }

    private Document createCollStatsCommand() {
        return new Document("collStats", (Object)this.endpoint.getCollection());
    }

    @Override
    public void run() {
        this.stoppedLatch = new CountDownLatch(1);
        while (this.keepRunning) {
            this.doRun();
            if (!this.keepRunning) continue;
            this.cursor.close();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Regenerating cursor with lastVal: {}, waiting {}ms first", this.tailTracking.lastVal, (Object)this.cursorRegenerationDelay);
            }
            if (this.cursorRegenerationDelayEnabled) {
                try {
                    Thread.sleep(this.cursorRegenerationDelay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.cursor = this.initializeCursor();
        }
        this.stopped = true;
        this.stoppedLatch.countDown();
    }

    protected void stop() throws Exception {
        if (LOG.isInfoEnabled()) {
            LOG.info("Stopping MongoDB Tailable Cursor consumer, bound to collection: {}", (Object)("db: " + this.endpoint.getDatabase() + ", col: " + this.endpoint.getCollection()));
        }
        this.keepRunning = false;
        if (this.cursor != null) {
            this.cursor.close();
        }
        this.awaitStopped();
        if (LOG.isInfoEnabled()) {
            LOG.info("Stopped MongoDB Tailable Cursor consumer, bound to collection: {}", (Object)("db: " + this.endpoint.getDatabase() + ", col: " + this.endpoint.getCollection()));
        }
    }

    private void doRun() {
        block6: {
            try {
                while (this.cursor.hasNext() && this.keepRunning) {
                    Document dbObj = (Document)this.cursor.next();
                    Exchange exchange = this.endpoint.createMongoDbExchange(dbObj);
                    try {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Sending exchange: {}, ObjectId: {}", (Object)exchange, dbObj.get((Object)"_id"));
                        }
                        this.consumer.getProcessor().process(exchange);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.tailTracking.setLastVal(dbObj);
                }
            }
            catch (MongoCursorNotFoundException e) {
                if (!this.keepRunning) break block6;
                LOG.debug("Cursor not found exception from MongoDB, will regenerate cursor. This is normal behaviour with tailable cursors.", (Throwable)e);
            }
        }
        this.tailTracking.persistToStore();
    }

    private MongoCursor<Document> initializeCursor() {
        MongoCursor answer;
        Object lastVal = this.tailTracking.lastVal;
        if (lastVal == null) {
            answer = this.dbCol.find().cursorType(CursorType.TailableAwait).iterator();
        } else {
            try (MongoCursor iterator = this.dbCol.find(Filters.gt((String)this.tailTracking.getIncreasingFieldName(), (Object)lastVal)).cursorType(CursorType.TailableAwait).iterator();){
                answer = iterator;
            }
        }
        return answer;
    }

    private void awaitStopped() throws InterruptedException {
        if (!this.stopped) {
            LOG.info("Going to wait for stopping");
            this.stoppedLatch.await();
        }
    }
}

