/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb3;

import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.mongodb3.MongoDbEndpoint;
import org.apache.camel.component.mongodb3.MongoDbTailTrackingManager;
import org.apache.camel.component.mongodb3.MongoDbTailingProcess;
import org.apache.camel.support.DefaultConsumer;

public class MongoDbTailableCursorConsumer
extends DefaultConsumer {
    private final MongoDbEndpoint endpoint;
    private ExecutorService executor;
    private MongoDbTailingProcess tailingProcess;

    public MongoDbTailableCursorConsumer(MongoDbEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.tailingProcess != null) {
            this.tailingProcess.stop();
        }
        if (this.executor != null) {
            this.endpoint.getCamelContext().getExecutorServiceManager().shutdown(this.executor);
            this.executor = null;
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.endpoint.getCamelContext().getExecutorServiceManager().newFixedThreadPool((Object)this, this.endpoint.getEndpointUri(), 1);
        MongoDbTailTrackingManager trackingManager = this.initTailTracking();
        this.tailingProcess = new MongoDbTailingProcess(this.endpoint, this, trackingManager);
        this.tailingProcess.initializeProcess();
        this.executor.execute(this.tailingProcess);
    }

    protected MongoDbTailTrackingManager initTailTracking() throws Exception {
        MongoDbTailTrackingManager answer = new MongoDbTailTrackingManager(this.endpoint.getMongoConnection(), this.endpoint.getTailTrackingConfig());
        answer.initialize();
        return answer;
    }
}

