/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.activemq.converter;

import javax.jms.MessageListener;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.activemq.converter.ActiveMQMessageConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.TypeConverterSupport;
import org.apache.camel.util.DoubleMap;

public class ActiveMQMessageConverterLoader
implements TypeConverterLoader {
    private final DoubleMap<Class<?>, Class<?>, BaseTypeConverter> converters = new DoubleMap(2);
    private volatile ActiveMQMessageConverter activeMQMessageConverter;

    private void registerConverters() {
        this.converters.put(ActiveMQMessage.class, Exchange.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ActiveMQMessageConverterLoader.this.getActiveMQMessageConverter().toMessage((Exchange)value);
            }
        });
        this.converters.put(Processor.class, MessageListener.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return ActiveMQMessageConverterLoader.this.getActiveMQMessageConverter().toProcessor((MessageListener)value);
            }
        });
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters();
        this.converters.forEach((k, v, c) -> registry.addTypeConverter(k, v, (TypeConverter)c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActiveMQMessageConverter getActiveMQMessageConverter() {
        if (this.activeMQMessageConverter == null) {
            ActiveMQMessageConverterLoader activeMQMessageConverterLoader = this;
            synchronized (activeMQMessageConverterLoader) {
                if (this.activeMQMessageConverter == null) {
                    this.activeMQMessageConverter = new ActiveMQMessageConverter();
                }
            }
        }
        return this.activeMQMessageConverter;
    }

    static abstract class BaseTypeConverter
    extends TypeConverterSupport {
        private final boolean allowNull;

        public BaseTypeConverter(boolean allowNull) {
            this.allowNull = allowNull;
        }

        public boolean allowNull() {
            return this.allowNull;
        }

        public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
            try {
                return (T)this.doConvert(exchange, value);
            }
            catch (TypeConversionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TypeConversionException(value, type, (Throwable)e);
            }
        }

        protected abstract Object doConvert(Exchange var1, Object var2) throws Exception;
    }
}

