/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.docker.consumer;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.EventsCmd;
import com.github.dockerjava.api.model.Event;
import com.github.dockerjava.core.command.EventsResultCallback;
import java.util.Date;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.docker.DockerClientFactory;
import org.apache.camel.component.docker.DockerComponent;
import org.apache.camel.component.docker.DockerEndpoint;
import org.apache.camel.component.docker.DockerHelper;
import org.apache.camel.support.DefaultConsumer;

public class DockerEventsConsumer
extends DefaultConsumer {
    private DockerEndpoint endpoint;
    private DockerComponent component;
    private EventsCmd eventsCmd;

    public DockerEventsConsumer(DockerEndpoint endpoint, Processor processor) throws Exception {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.component = (DockerComponent)endpoint.getComponent();
    }

    public DockerEndpoint getEndpoint() {
        return (DockerEndpoint)super.getEndpoint();
    }

    private long processInitialEvent() {
        long currentTime = new Date().getTime();
        Long initialRange = DockerHelper.getProperty("CamelDockerInitialRange", this.endpoint.getConfiguration(), null, Long.class);
        if (initialRange != null) {
            currentTime -= initialRange.longValue();
        }
        return currentTime;
    }

    protected void doStart() throws Exception {
        this.eventsCmd = DockerClientFactory.getDockerClient(this.component, this.endpoint.getConfiguration(), null).eventsCmd().withSince(String.valueOf(this.processInitialEvent()));
        this.eventsCmd.exec((ResultCallback)new EventsCallback());
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.eventsCmd.close();
        super.doStop();
    }

    protected class EventsCallback
    extends EventsResultCallback {
        protected EventsCallback() {
        }

        public void onNext(Event event) {
            DockerEventsConsumer.this.log.debug("Received Docker Event: {}", (Object)event);
            final Exchange exchange = DockerEventsConsumer.this.getEndpoint().createExchange();
            Message message = exchange.getIn();
            message.setBody((Object)event);
            try {
                DockerEventsConsumer.this.log.trace("Processing exchange [{}]...", (Object)exchange);
                DockerEventsConsumer.this.getAsyncProcessor().process(exchange, new AsyncCallback(){

                    public void done(boolean doneSync) {
                        DockerEventsConsumer.this.log.trace("Done processing exchange [{}]...", (Object)exchange);
                    }
                });
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
            }
            if (exchange.getException() != null) {
                DockerEventsConsumer.this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
            }
        }
    }
}

