/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.influxdb;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.influxdb.InfluxDbComponent;
import org.apache.camel.component.influxdb.InfluxDbProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultEndpoint;
import org.influxdb.InfluxDB;

@UriEndpoint(firstVersion="2.18.0", scheme="influxdb", title="InfluxDB", syntax="influxdb:connectionBean", label="database", producerOnly=true)
public class InfluxDbEndpoint
extends DefaultEndpoint {
    private InfluxDB influxDB;
    @UriPath
    @Metadata(required=true)
    private String connectionBean;
    @UriParam
    private String databaseName;
    @UriParam(defaultValue="default")
    private String retentionPolicy = "default";
    @UriParam(defaultValue="false")
    private boolean batch;
    @UriParam(defaultValue="insert")
    private String operation = "insert";
    @UriParam
    private String query;

    public InfluxDbEndpoint(String uri, InfluxDbComponent component) {
        super(uri, (Component)component);
    }

    public Producer createProducer() throws Exception {
        return new InfluxDbProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    protected void doStart() throws Exception {
        this.influxDB = (InfluxDB)CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)this.connectionBean, InfluxDB.class);
        this.log.debug("Resolved the connection with the name {} as {}", (Object)this.connectionBean, (Object)this.influxDB);
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    public boolean isSingleton() {
        return true;
    }

    public InfluxDB getInfluxDB() {
        return this.influxDB;
    }

    public void setInfluxDB(InfluxDB influxDB) {
        this.influxDB = influxDB;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getRetentionPolicy() {
        return this.retentionPolicy;
    }

    public void setRetentionPolicy(String retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
    }

    public String getConnectionBean() {
        return this.connectionBean;
    }

    public void setConnectionBean(String connectionBean) {
        this.connectionBean = connectionBean;
    }

    public boolean isBatch() {
        return this.batch;
    }

    public void setBatch(boolean batch) {
        this.batch = batch;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }
}

