/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.crypto;

import java.io.IOException;
import java.security.NoSuchProviderException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.converter.crypto.PGPDataFormatUtil;
import org.apache.camel.converter.crypto.PGPKeyAccessDataFormat;
import org.apache.camel.converter.crypto.PGPPassphraseAccessor;
import org.apache.camel.converter.crypto.PGPPublicKeyAccessor;
import org.apache.camel.converter.crypto.PGPSecretKeyAccessor;
import org.apache.camel.converter.crypto.PGPSecretKeyAndPrivateKeyAndUserId;
import org.apache.camel.spi.annotations.Dataformat;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;

@Dataformat(value="pgp")
public class PGPDataFormat
extends PGPKeyAccessDataFormat
implements PGPPublicKeyAccessor,
PGPSecretKeyAccessor {
    public static final String KEY_FILE_NAME = "CamelPGPDataFormatKeyFileName";
    public static final String ENCRYPTION_KEY_RING = "CamelPGPDataFormatEncryptionKeyRing";
    public static final String KEY_PASSWORD = "CamelPGPDataFormatKeyPassword";
    public static final String SIGNATURE_KEY_FILE_NAME = "CamelPGPDataFormatSignatureKeyFileName";
    public static final String SIGNATURE_KEY_RING = "CamelPGPDataFormatSignatureKeyRing";
    public static final String SIGNATURE_KEY_PASSWORD = "CamelPGPDataFormatSignatureKeyPassword";
    private String password;
    private String keyFileName;
    private byte[] encryptionKeyRing;
    private String signaturePassword;
    private String signatureKeyFileName;
    private byte[] signatureKeyRing;
    private PGPPassphraseAccessor passphraseAccessor;

    public PGPDataFormat() {
        this.publicKeyAccessor = this;
        this.secretKeyAccessor = this;
    }

    protected String findKeyFileName(Exchange exchange) {
        return (String)exchange.getIn().getHeader(KEY_FILE_NAME, (Object)this.getKeyFileName(), String.class);
    }

    protected byte[] findEncryptionKeyRing(Exchange exchange) {
        return (byte[])exchange.getIn().getHeader(ENCRYPTION_KEY_RING, (Object)this.getEncryptionKeyRing(), byte[].class);
    }

    protected String findKeyPassword(Exchange exchange) {
        return (String)exchange.getIn().getHeader(KEY_PASSWORD, (Object)this.getPassword(), String.class);
    }

    protected String findSignatureKeyFileName(Exchange exchange) {
        return (String)exchange.getIn().getHeader(SIGNATURE_KEY_FILE_NAME, (Object)this.getSignatureKeyFileName(), String.class);
    }

    protected byte[] findSignatureKeyRing(Exchange exchange) {
        return (byte[])exchange.getIn().getHeader(SIGNATURE_KEY_RING, (Object)this.getSignatureKeyRing(), byte[].class);
    }

    protected String findSignatureKeyPassword(Exchange exchange) {
        String sigPassword = (String)exchange.getIn().getHeader(SIGNATURE_KEY_PASSWORD, (Object)this.getSignaturePassword(), String.class);
        if (sigPassword != null) {
            return sigPassword;
        }
        if (this.passphraseAccessor != null) {
            return this.passphraseAccessor.getPassphrase(this.findSignatureKeyUserid(exchange));
        }
        return null;
    }

    public List<PGPSecretKeyAndPrivateKeyAndUserId> determineSecretKeysWithPrivateKeyAndUserId(Exchange exchange, String sigKeyFileName, List<String> sigKeyUserids, String sigKeyPassword, byte[] sigKeyRing) throws IOException, PGPException, NoSuchProviderException {
        Map<String, String> sigKeyUserId2Password = this.determineSignatureKeyUserId2Password(sigKeyUserids, sigKeyPassword);
        List<PGPSecretKeyAndPrivateKeyAndUserId> sigSecretKeysWithPrivateKeyAndUserId = PGPDataFormatUtil.findSecretKeysWithPrivateKeyAndUserId(exchange.getContext(), sigKeyFileName, sigKeyRing, sigKeyUserId2Password, this.getProvider());
        if (sigSecretKeysWithPrivateKeyAndUserId.isEmpty()) {
            throw new IllegalArgumentException(String.format("Cannot PGP sign message. No secret key found for User IDs %s. Either add keys with this User IDs to the secret keyring or change the configured User IDs.", sigKeyUserids));
        }
        return sigSecretKeysWithPrivateKeyAndUserId;
    }

    public Map<String, String> determineSignatureKeyUserId2Password(List<String> sigKeyUserids, String sigKeyPassword) {
        LinkedHashMap<String, String> sigKeyUserId2Password = new LinkedHashMap<String, String>(sigKeyUserids.size());
        for (String sigKeyUserid : sigKeyUserids) {
            if (sigKeyPassword == null) {
                sigKeyPassword = this.passphraseAccessor.getPassphrase(sigKeyUserid);
            }
            if (sigKeyPassword == null) {
                throw new IllegalArgumentException(String.format("No passphrase specified for signature key user ID %s. Either specify a passphrase or remove this user ID from the configuration.", sigKeyUserid));
            }
            sigKeyUserId2Password.put(sigKeyUserid, sigKeyPassword);
        }
        return sigKeyUserId2Password;
    }

    public void setKeyFileName(String keyFileName) {
        this.keyFileName = keyFileName;
    }

    public String getKeyFileName() {
        return this.keyFileName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setSignatureKeyFileName(String signatureKeyFileName) {
        this.signatureKeyFileName = signatureKeyFileName;
    }

    public String getSignatureKeyFileName() {
        return this.signatureKeyFileName;
    }

    public void setSignaturePassword(String signaturePassword) {
        this.signaturePassword = signaturePassword;
    }

    public String getSignaturePassword() {
        return this.signaturePassword;
    }

    public byte[] getEncryptionKeyRing() {
        return this.encryptionKeyRing;
    }

    public void setEncryptionKeyRing(byte[] encryptionKeyRing) {
        this.encryptionKeyRing = encryptionKeyRing;
    }

    public byte[] getSignatureKeyRing() {
        return this.signatureKeyRing;
    }

    public void setSignatureKeyRing(byte[] signatureKeyRing) {
        this.signatureKeyRing = signatureKeyRing;
    }

    public PGPPassphraseAccessor getPassphraseAccessor() {
        return this.passphraseAccessor;
    }

    public void setPassphraseAccessor(PGPPassphraseAccessor passphraseAccessor) {
        this.passphraseAccessor = passphraseAccessor;
    }

    @Override
    public List<PGPPublicKey> getEncryptionKeys(Exchange exchange, List<String> useridParts) throws Exception {
        return PGPDataFormatUtil.findPublicKeys(exchange.getContext(), this.findKeyFileName(exchange), this.findEncryptionKeyRing(exchange), useridParts, true);
    }

    @Override
    public List<PGPSecretKeyAndPrivateKeyAndUserId> getSignerKeys(Exchange exchange, List<String> useridParts) throws Exception {
        String sigKeyFileName = this.findSignatureKeyFileName(exchange);
        String sigKeyPassword = this.findSignatureKeyPassword(exchange);
        byte[] sigKeyRing = this.findSignatureKeyRing(exchange);
        if (sigKeyFileName == null && sigKeyRing == null || useridParts == null || useridParts.isEmpty() || sigKeyPassword == null && this.passphraseAccessor == null) {
            return Collections.emptyList();
        }
        return this.determineSecretKeysWithPrivateKeyAndUserId(exchange, sigKeyFileName, useridParts, sigKeyPassword, sigKeyRing);
    }

    @Override
    public PGPPrivateKey getPrivateKey(Exchange exchange, long keyId) throws Exception {
        return PGPDataFormatUtil.findPrivateKeyWithKeyId(exchange.getContext(), this.findKeyFileName(exchange), this.findEncryptionKeyRing(exchange), keyId, this.findKeyPassword(exchange), this.getPassphraseAccessor(), this.getProvider());
    }

    @Override
    public PGPPublicKey getPublicKey(Exchange exchange, long keyId, List<String> userIdParts) throws Exception {
        PGPPublicKeyRingCollection publicKeyringCollection = PGPDataFormatUtil.getPublicKeyRingCollection(exchange.getContext(), this.findSignatureKeyFileName(exchange), this.findSignatureKeyRing(exchange), false);
        return PGPDataFormatUtil.getPublicKeyWithKeyIdAndUserID(keyId, userIdParts, publicKeyringCollection);
    }

    @Override
    public void setPublicKeyAccessor(PGPPublicKeyAccessor publicKeyAccessor) {
        throw new UnsupportedOperationException("Use PGPKeyAccessDataFormat if you want to set the public key access");
    }

    @Override
    public void setSecretKeyAccessor(PGPSecretKeyAccessor secretKeyAccessor) {
        throw new UnsupportedOperationException("Use PGPKeyAccessDataFormat if you want to set the secret key access");
    }
}

