/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atomix.client;

import io.atomix.AtomixClient;
import io.atomix.catalyst.transport.Transport;
import java.io.InputStream;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.component.atomix.client.AtomixClientConfiguration;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.ObjectHelper;

public final class AtomixClientHelper {
    private AtomixClientHelper() {
    }

    public static AtomixClient createClient(CamelContext camelContext, AtomixClientConfiguration configuration) throws Exception {
        AtomixClient atomix = (AtomixClient)configuration.getAtomix();
        if (atomix == null) {
            AtomixClient.Builder atomixBuilder;
            String uri = configuration.getConfigurationUri();
            if (ObjectHelper.isNotEmpty((Object)uri)) {
                uri = camelContext.resolvePropertyPlaceholders(uri);
                try (InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)camelContext, (String)uri);){
                    Properties properties = new Properties();
                    properties.load(is);
                    atomixBuilder = AtomixClient.builder((Properties)properties);
                }
            } else {
                atomixBuilder = AtomixClient.builder();
            }
            if (configuration.getTransport() != null) {
                atomixBuilder.withTransport((Transport)camelContext.getInjector().newInstance(configuration.getTransport()));
            }
            atomix = atomixBuilder.build();
        }
        return atomix;
    }
}

