/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ecs;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.ecs.ECSComponentVerifierExtension;
import org.apache.camel.component.aws.ecs.ECSConfiguration;
import org.apache.camel.component.aws.ecs.ECSEndpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;

@org.apache.camel.spi.annotations.Component(value="aws-ecs")
public class ECSComponent
extends DefaultComponent {
    @Metadata
    private String accessKey;
    @Metadata
    private String secretKey;
    @Metadata
    private String region;
    @Metadata(label="advanced")
    private ECSConfiguration configuration = new ECSConfiguration();

    public ECSComponent() {
        this(null);
    }

    public ECSComponent(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new ECSComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        ECSConfiguration configuration = this.configuration.copy();
        this.setProperties(configuration, parameters);
        if (ObjectHelper.isEmpty((Object)configuration.getAccessKey())) {
            this.setAccessKey(this.accessKey);
        }
        if (ObjectHelper.isEmpty((Object)configuration.getSecretKey())) {
            this.setSecretKey(this.secretKey);
        }
        if (ObjectHelper.isEmpty((Object)configuration.getRegion())) {
            this.setRegion(this.region);
        }
        if (configuration.getEcsClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("Amazon ecs client or accessKey and secretKey must be specified");
        }
        ECSEndpoint endpoint = new ECSEndpoint(uri, (Component)this, configuration);
        return endpoint;
    }

    public ECSConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ECSConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getAccessKey() {
        return this.configuration.getAccessKey();
    }

    public void setAccessKey(String accessKey) {
        this.configuration.setAccessKey(accessKey);
    }

    public String getSecretKey() {
        return this.configuration.getSecretKey();
    }

    public void setSecretKey(String secretKey) {
        this.configuration.setSecretKey(secretKey);
    }

    public String getRegion() {
        return this.configuration.getRegion();
    }

    public void setRegion(String region) {
        this.configuration.setRegion(region);
    }
}

