/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.commands;

import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.camel.commands.AbstractRouteCommand;
import org.apache.camel.commands.CamelController;
import org.apache.camel.commands.StringEscape;
import org.apache.camel.support.dump.RouteStatDump;
import org.apache.camel.util.ObjectHelper;

public class RouteInfoCommand
extends AbstractRouteCommand {
    public static final String XML_TIMESTAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final String OUTPUT_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private StringEscape stringEscape;

    public RouteInfoCommand(String route, String context) {
        super(route, context);
    }

    public void setStringEscape(StringEscape stringEscape) {
        this.stringEscape = stringEscape;
    }

    @Override
    public void executeOnRoute(CamelController camelController, String contextName, String routeId, PrintStream out, PrintStream err) throws Exception {
        out.println(this.stringEscape.unescapeJava("\u001b[1mCamel Route " + routeId + "\u001b[0m"));
        out.println(this.stringEscape.unescapeJava("\tCamel Context: " + contextName));
        String xml = camelController.getRouteStatsAsXml(routeId, contextName, true, false);
        if (xml != null) {
            String text;
            Date date;
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{RouteStatDump.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            RouteStatDump route = (RouteStatDump)unmarshaller.unmarshal((Reader)new StringReader(xml));
            out.println(this.stringEscape.unescapeJava("\tState: " + route.getState()));
            out.println(this.stringEscape.unescapeJava("\tState: " + route.getState()));
            out.println("");
            out.println("");
            out.println(this.stringEscape.unescapeJava("\u001b[1mStatistics\u001b[0m"));
            long total = route.getExchangesCompleted() + route.getExchangesFailed();
            out.println(this.stringEscape.unescapeJava("\tExchanges Total: " + total));
            out.println(this.stringEscape.unescapeJava("\tExchanges Completed: " + route.getExchangesCompleted()));
            out.println(this.stringEscape.unescapeJava("\tExchanges Failed: " + route.getExchangesFailed()));
            out.println(this.stringEscape.unescapeJava("\tExchanges Inflight: " + route.getExchangesInflight()));
            out.println(this.stringEscape.unescapeJava("\tMin Processing Time: " + route.getMinProcessingTime() + " ms"));
            out.println(this.stringEscape.unescapeJava("\tMax Processing Time: " + route.getMaxProcessingTime() + " ms"));
            out.println(this.stringEscape.unescapeJava("\tMean Processing Time: " + route.getMeanProcessingTime() + " ms"));
            out.println(this.stringEscape.unescapeJava("\tTotal Processing Time: " + route.getTotalProcessingTime() + " ms"));
            out.println(this.stringEscape.unescapeJava("\tLast Processing Time: " + route.getLastProcessingTime() + " ms"));
            out.println(this.stringEscape.unescapeJava("\tDelta Processing Time: " + route.getDeltaProcessingTime() + " ms"));
            if (ObjectHelper.isEmpty((Object)route.getStartTimestamp())) {
                out.println(this.stringEscape.unescapeJava("\tStart Statistics Date:"));
            } else {
                date = new SimpleDateFormat(XML_TIMESTAMP_FORMAT).parse(route.getStartTimestamp());
                text = new SimpleDateFormat(OUTPUT_TIMESTAMP_FORMAT).format(date);
                out.println(this.stringEscape.unescapeJava("\tStart Statistics Date: " + text));
            }
            if (ObjectHelper.isEmpty((Object)route.getResetTimestamp())) {
                out.println(this.stringEscape.unescapeJava("\tReset Statistics Date:"));
            } else {
                date = new SimpleDateFormat(XML_TIMESTAMP_FORMAT).parse(route.getResetTimestamp());
                text = new SimpleDateFormat(OUTPUT_TIMESTAMP_FORMAT).format(date);
                out.println(this.stringEscape.unescapeJava("\tReset Statistics Date: " + text));
            }
            if (ObjectHelper.isEmpty((Object)route.getFirstExchangeCompletedTimestamp())) {
                out.println(this.stringEscape.unescapeJava("\tFirst Exchange Date:"));
            } else {
                date = new SimpleDateFormat(XML_TIMESTAMP_FORMAT).parse(route.getFirstExchangeCompletedTimestamp());
                text = new SimpleDateFormat(OUTPUT_TIMESTAMP_FORMAT).format(date);
                out.println(this.stringEscape.unescapeJava("\tFirst Exchange Date: " + text));
            }
            if (ObjectHelper.isEmpty((Object)route.getLastExchangeCompletedTimestamp())) {
                out.println(this.stringEscape.unescapeJava("\tLast Exchange Date:"));
            } else {
                date = new SimpleDateFormat(XML_TIMESTAMP_FORMAT).parse(route.getLastExchangeCompletedTimestamp());
                text = new SimpleDateFormat(OUTPUT_TIMESTAMP_FORMAT).format(date);
                out.println(this.stringEscape.unescapeJava("\tLast Exchange Date: " + text));
            }
        }
    }
}

