/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.commands;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.camel.commands.AbstractContextCommand;
import org.apache.camel.commands.CamelController;
import org.apache.camel.support.JSonSchemaHelper;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.util.URISupport;

public class EndpointExplainCommand
extends AbstractContextCommand {
    private boolean verbose;
    private String filter;

    public EndpointExplainCommand(String name, boolean verbose, String filter) {
        super(name);
        this.verbose = verbose;
        this.filter = filter;
    }

    @Override
    protected Object performContextCommand(CamelController camelController, String contextName, PrintStream out, PrintStream err) throws Exception {
        List<Map<String, String>> endpoints = camelController.getEndpoints(contextName);
        if (endpoints == null || endpoints.isEmpty()) {
            return null;
        }
        if (this.filter != null) {
            Iterator<Map<String, String>> it = endpoints.iterator();
            while (it.hasNext()) {
                Map<String, String> row = it.next();
                if (PatternHelper.matchPattern((String)row.get("uri"), (String)this.filter)) continue;
                it.remove();
            }
        }
        for (Map<String, String> row : endpoints) {
            String json = camelController.explainEndpointAsJSon(this.context, row.get("uri"), this.verbose);
            if (json == null) continue;
            out.println("Context:       " + this.context);
            String uri = URISupport.sanitizeUri((String)row.get("uri"));
            String header = "Uri:           " + uri;
            out.println(header);
            for (int i = 0; i < header.length(); ++i) {
                out.print('-');
            }
            out.println();
            List options = JSonSchemaHelper.parseJsonSchema((String)"properties", (String)json, (boolean)true);
            for (Map option : options) {
                String description;
                String defaultValue;
                String value;
                String javaType;
                String type;
                String group;
                out.print("Option:        ");
                out.println((String)option.get("name"));
                String kind = (String)option.get("kind");
                if (kind != null) {
                    out.print("Kind:          ");
                    out.println(kind);
                }
                if ((group = (String)option.get("group")) != null) {
                    out.print("Group:         ");
                    out.println(group);
                }
                if ((type = (String)option.get("type")) != null) {
                    out.print("Type:          ");
                    out.println(type);
                }
                if ((javaType = (String)option.get("javaType")) != null) {
                    out.print("Java Type:     ");
                    out.println(javaType);
                }
                if ((value = (String)option.get("value")) != null) {
                    out.print("Value:         ");
                    out.println(value);
                }
                if ((defaultValue = (String)option.get("defaultValue")) != null) {
                    out.print("Default Value: ");
                    out.println(defaultValue);
                }
                if ((description = (String)option.get("description")) != null) {
                    out.print("Description:   ");
                    out.println(description);
                }
                out.println();
            }
            if (!options.isEmpty()) continue;
            out.println();
        }
        return null;
    }
}

