/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hipchat;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.hipchat.HipchatComponent;
import org.apache.camel.component.hipchat.HipchatConfiguration;
import org.apache.camel.component.hipchat.HipchatConsumer;
import org.apache.camel.component.hipchat.HipchatProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;

@UriEndpoint(firstVersion="2.15.0", scheme="hipchat", title="Hipchat", syntax="hipchat:protocol:host:port", label="api,cloud")
public class HipchatEndpoint
extends ScheduledPollEndpoint {
    @UriParam
    private HipchatConfiguration configuration = new HipchatConfiguration();

    public HipchatEndpoint(String uri, HipchatComponent component) {
        super(uri, (Component)component);
    }

    public Producer createProducer() throws Exception {
        return new HipchatProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        HipchatConsumer consumer = new HipchatConsumer(this, processor);
        consumer.setDelay(5000L);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public boolean isSingleton() {
        return true;
    }

    public HipchatConfiguration getConfiguration() {
        return this.configuration;
    }
}

