/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka;

import java.lang.reflect.Field;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.kafka.KafkaComponent;
import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.camel.component.kafka.KafkaConsumer;
import org.apache.camel.component.kafka.KafkaProducer;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.SynchronousDelegateProducer;
import org.apache.camel.util.CastUtils;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.Partitioner;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;

@UriEndpoint(firstVersion="2.13.0", scheme="kafka", title="Kafka", syntax="kafka:topic", label="messaging")
public class KafkaEndpoint
extends DefaultEndpoint
implements MultipleConsumersSupport {
    @UriParam
    private KafkaConfiguration configuration = new KafkaConfiguration();

    public KafkaEndpoint() {
    }

    public KafkaEndpoint(String endpointUri, KafkaComponent component) {
        super(endpointUri, (Component)component);
    }

    public KafkaComponent getComponent() {
        return (KafkaComponent)super.getComponent();
    }

    public KafkaConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(KafkaConfiguration configuration) {
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        KafkaConsumer consumer = new KafkaConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public Producer createProducer() throws Exception {
        KafkaProducer producer = this.createProducer(this);
        if (this.isSynchronous()) {
            return new SynchronousDelegateProducer((Producer)producer);
        }
        return producer;
    }

    public boolean isSingleton() {
        return true;
    }

    public boolean isMultipleConsumersSupported() {
        return true;
    }

    private void loadParitionerClass(ClassResolver resolver, Properties props) {
        this.replaceWithClass(props, "partitioner.class", resolver, Partitioner.class);
    }

    <T> Class<T> loadClass(Object o, ClassResolver resolver, Class<T> type) {
        if (o == null || o instanceof Class) {
            return CastUtils.cast((Class)((Class)o));
        }
        String name = o.toString();
        Class c = resolver.resolveClass(name, type);
        if (c == null) {
            c = resolver.resolveClass(name, type, ((Object)((Object)this)).getClass().getClassLoader());
        }
        if (c == null) {
            c = resolver.resolveClass(name, type, org.apache.kafka.clients.producer.KafkaProducer.class.getClassLoader());
        }
        return c;
    }

    void replaceWithClass(Properties props, String key, ClassResolver resolver, Class<?> type) {
        Class<?> c = this.loadClass(props.get(key), resolver, type);
        if (c != null) {
            props.put(key, c);
        }
    }

    public void updateClassProperties(Properties props) {
        block6: {
            try {
                if (this.getCamelContext() == null) break block6;
                ClassResolver resolver = this.getCamelContext().getClassResolver();
                this.replaceWithClass(props, "key.serializer", resolver, Serializer.class);
                this.replaceWithClass(props, "value.serializer", resolver, Serializer.class);
                this.replaceWithClass(props, "key.deserializer", resolver, Deserializer.class);
                this.replaceWithClass(props, "value.deserializer", resolver, Deserializer.class);
                try {
                    Field f = ProducerConfig.class.getDeclaredField("PARTITIONER_CLASS_CONFIG");
                    if (f != null) {
                        this.loadParitionerClass(resolver, props);
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
                catch (SecurityException securityException) {}
            }
            catch (Throwable t) {
                this.log.debug("Problem loading classes for Serializers", t);
            }
        }
    }

    public ExecutorService createExecutor() {
        return this.getCamelContext().getExecutorServiceManager().newFixedThreadPool((Object)this, "KafkaConsumer[" + this.configuration.getTopic() + "]", this.configuration.getConsumerStreams());
    }

    public ExecutorService createProducerExecutor() {
        int core = this.getConfiguration().getWorkerPoolCoreSize();
        int max = this.getConfiguration().getWorkerPoolMaxSize();
        return this.getCamelContext().getExecutorServiceManager().newThreadPool((Object)this, "KafkaProducer[" + this.configuration.getTopic() + "]", core, max);
    }

    public Exchange createKafkaExchange(ConsumerRecord record) {
        Exchange exchange = super.createExchange();
        Message message = exchange.getIn();
        message.setHeader("kafka.PARTITION", (Object)record.partition());
        message.setHeader("kafka.TOPIC", (Object)record.topic());
        message.setHeader("kafka.OFFSET", (Object)record.offset());
        message.setHeader("kafka.HEADERS", (Object)record.headers());
        message.setHeader("kafka.TIMESTAMP", (Object)record.timestamp());
        if (record.key() != null) {
            message.setHeader("kafka.KEY", record.key());
        }
        message.setBody(record.value());
        return exchange;
    }

    protected KafkaProducer createProducer(KafkaEndpoint endpoint) {
        return new KafkaProducer(endpoint);
    }
}

