/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fastjson;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.service.ServiceSupport;

@Dataformat(value="json-fastjson")
public class FastjsonDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    private FastJsonConfig config;
    private Class<?> unmarshalType;
    private Type unmarshalGenericType;
    private boolean serializeNulls;
    private boolean prettyPrint;
    private String dateFormatPattern;
    private boolean contentTypeHeader = true;

    public FastjsonDataFormat() {
        this(Object.class);
    }

    public FastjsonDataFormat(Class<?> unmarshalType) {
        this(null, unmarshalType);
    }

    public FastjsonDataFormat(FastJsonConfig config, Class<?> unmarshalType) {
        this.config = config;
        this.unmarshalType = unmarshalType;
    }

    public FastjsonDataFormat(Type unmarshalGenericType) {
        this(null, unmarshalGenericType);
    }

    public FastjsonDataFormat(FastJsonConfig config, Type unmarshalGenericType) {
        this.config = config;
        this.unmarshalGenericType = unmarshalGenericType;
    }

    public String getDataFormatName() {
        return "json-fastjson";
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        int len = JSON.writeJSONString((OutputStream)stream, (Charset)this.config.getCharset(), (Object)graph, (SerializeConfig)this.config.getSerializeConfig(), (SerializeFilter[])this.config.getSerializeFilters(), (String)this.config.getDateFormat(), (int)JSON.DEFAULT_GENERATE_FEATURE, (SerializerFeature[])this.config.getSerializerFeatures());
        if (this.contentTypeHeader) {
            Message message = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
            message.setHeader("Content-Type", (Object)"application/json");
            message.setHeader("Content-Length", (Object)len);
        }
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        if (this.unmarshalGenericType == null) {
            return JSON.parseObject((InputStream)stream, (Charset)this.config.getCharset(), this.unmarshalType, (Feature[])this.config.getFeatures());
        }
        return JSON.parseObject((InputStream)stream, (Charset)this.config.getCharset(), (Type)this.unmarshalGenericType, (Feature[])this.config.getFeatures());
    }

    protected void doStart() throws Exception {
        if (this.config == null) {
            ArrayList<SerializerFeature> serializerFeatureList = new ArrayList<SerializerFeature>();
            this.config = new FastJsonConfig();
            if (this.prettyPrint) {
                serializerFeatureList.add(SerializerFeature.PrettyFormat);
            }
            if (this.serializeNulls) {
                serializerFeatureList.add(SerializerFeature.WriteMapNullValue);
                serializerFeatureList.add(SerializerFeature.WriteNullBooleanAsFalse);
                serializerFeatureList.add(SerializerFeature.WriteNullListAsEmpty);
                serializerFeatureList.add(SerializerFeature.WriteNullNumberAsZero);
                serializerFeatureList.add(SerializerFeature.WriteNullStringAsEmpty);
            }
            if (this.dateFormatPattern != null) {
                serializerFeatureList.add(SerializerFeature.WriteDateUseDateFormat);
                this.config.setDateFormat(this.dateFormatPattern);
            }
        }
    }

    protected void doStop() throws Exception {
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    public Type getUnmarshalGenericType() {
        return this.unmarshalType;
    }

    public void setUnmarshalGenericType(Type unmarshalGenericType) {
        this.unmarshalGenericType = unmarshalGenericType;
    }

    public boolean isSerializeNulls() {
        return this.serializeNulls;
    }

    public void setSerializeNulls(boolean serializeNulls) {
        this.serializeNulls = serializeNulls;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public String getDateFormatPattern() {
        return this.dateFormatPattern;
    }

    public void setDateFormatPattern(String dateFormatPattern) {
        this.dateFormatPattern = dateFormatPattern;
    }

    public boolean isContentTypeHeader() {
        return this.contentTypeHeader;
    }

    public void setContentTypeHeader(boolean contentTypeHeader) {
        this.contentTypeHeader = contentTypeHeader;
    }

    public FastJsonConfig getConfig() {
        return this.config;
    }
}

