/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.converter;

import javax.xml.transform.Source;
import org.apache.camel.Exchange;
import org.apache.camel.StreamCache;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.cxf.CxfPayload;
import org.apache.camel.component.cxf.converter.CxfPayloadConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.TypeConverterSupport;
import org.apache.camel.util.DoubleMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CxfPayloadConverterLoader
implements TypeConverterLoader {
    private final DoubleMap<Class<?>, Class<?>, BaseTypeConverter> converters = new DoubleMap(8);

    private void registerConverters() {
        this.converters.put(Source.class, CxfPayload.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CxfPayloadConverter.cxfPayLoadToSource((CxfPayload)value, exchange);
            }
        });
        this.converters.put(StreamCache.class, CxfPayload.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CxfPayloadConverter.cxfPayLoadToStreamCache((CxfPayload)value, exchange);
            }
        });
        this.converters.put(CxfPayload.class, Source.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CxfPayloadConverter.sourceToCxfPayload((Source)value, exchange);
            }
        });
        this.converters.put(CxfPayload.class, Document.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CxfPayloadConverter.documentToCxfPayload((Document)value, exchange);
            }
        });
        this.converters.put(CxfPayload.class, Element.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CxfPayloadConverter.elementToCxfPayload((Element)value, exchange);
            }
        });
        this.converters.put(CxfPayload.class, NodeList.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CxfPayloadConverter.nodeListToCxfPayload((NodeList)value, exchange);
            }
        });
        this.converters.put(Node.class, CxfPayload.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CxfPayloadConverter.cxfPayLoadToNode((CxfPayload)value, exchange);
            }
        });
        this.converters.put(NodeList.class, CxfPayload.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return CxfPayloadConverter.cxfPayloadToNodeList((CxfPayload)value, exchange);
            }
        });
    }

    public void load(final TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters();
        this.converters.forEach((k, v, c) -> registry.addTypeConverter(k, v, (TypeConverter)c));
        registry.addFallbackTypeConverter((TypeConverter)new TypeConverterSupport(){

            public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
                try {
                    return CxfPayloadConverter.convertTo(type, exchange, value, registry);
                }
                catch (TypeConversionException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new TypeConversionException(value, type, (Throwable)e);
                }
            }
        }, false);
    }

    static abstract class BaseTypeConverter
    extends TypeConverterSupport {
        private final boolean allowNull;

        public BaseTypeConverter(boolean allowNull) {
            this.allowNull = allowNull;
        }

        public boolean allowNull() {
            return this.allowNull;
        }

        public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
            try {
                return (T)this.doConvert(exchange, value);
            }
            catch (TypeConversionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TypeConversionException(value, type, (Throwable)e);
            }
        }

        protected abstract Object doConvert(Exchange var1, Object var2) throws Exception;
    }
}

