/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast;

import java.util.Date;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.hazelcast.HazelcastOperation;
import org.apache.camel.util.ObjectHelper;

public final class HazelcastComponentHelper {
    private HazelcastComponentHelper() {
    }

    public static void copyHeaders(Exchange ex) {
        Map headers = ex.getIn().getHeaders();
        if (headers.containsKey("CamelHazelcastObjectId")) {
            headers.remove("CamelHazelcastObjectId");
        }
        if (headers.containsKey("CamelHazelcastOperationType")) {
            headers.remove("CamelHazelcastOperationType");
        }
        if (ex.hasOut()) {
            ex.getOut().setHeaders(headers);
        }
    }

    public static void setListenerHeaders(Exchange ex, String listenerType, String listenerAction, String cacheName) {
        ex.getIn().setHeader("CamelHazelcastCacheName", (Object)cacheName);
        HazelcastComponentHelper.setListenerHeaders(ex, listenerType, listenerAction);
    }

    public static void setListenerHeaders(Exchange ex, String listenerType, String listenerAction) {
        ex.getIn().setHeader("CamelHazelcastListenerAction", (Object)listenerAction);
        ex.getIn().setHeader("CamelHazelcastListenerType", (Object)listenerType);
        ex.getIn().setHeader("CamelHazelcastListenerTime", (Object)new Date().getTime());
    }

    public static HazelcastOperation lookupOperation(Exchange exchange, HazelcastOperation defaultOperation) {
        String operationName = (String)exchange.getIn().getHeader("CamelHazelcastOperationType", String.class);
        return ObjectHelper.isEmpty((Object)operationName) ? defaultOperation : HazelcastOperation.getHazelcastOperation(operationName);
    }
}

