/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.yammer;

import java.util.concurrent.TimeUnit;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.yammer.YammerEndpoint;
import org.apache.camel.component.yammer.YammerFunctionType;
import org.apache.camel.component.yammer.model.Messages;
import org.apache.camel.support.ScheduledPollConsumer;
import org.apache.camel.util.ObjectHelper;
import org.codehaus.jackson.map.ObjectMapper;

public class YammerMessagePollingConsumer
extends ScheduledPollConsumer {
    private final YammerEndpoint endpoint;
    private final String apiUrl;

    public YammerMessagePollingConsumer(YammerEndpoint endpoint, Processor processor) throws Exception {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        long delay = endpoint.getConfig().getDelay();
        this.setDelay(delay);
        this.setTimeUnit(TimeUnit.MILLISECONDS);
        this.apiUrl = this.getApiUrl();
    }

    private String getApiUrl() throws Exception {
        String threaded;
        long newerThan;
        long olderThan;
        StringBuilder url = new StringBuilder();
        String function = this.endpoint.getConfig().getFunction();
        switch (YammerFunctionType.fromUri(function)) {
            case MESSAGES: {
                url.append("https://www.yammer.com/api/v1/");
                url.append(function);
                url.append(".json");
                break;
            }
            case ALGO: 
            case FOLLOWING: 
            case MY_FEED: 
            case PRIVATE: 
            case SENT: 
            case RECEIVED: {
                url.append("https://www.yammer.com/api/v1/");
                url.append("messages/");
                url.append(function);
                url.append(".json");
                break;
            }
            default: {
                throw new Exception(String.format("%s is not a valid Yammer message function type.", function));
            }
        }
        StringBuilder args = new StringBuilder();
        int limit = this.endpoint.getConfig().getLimit();
        if (limit > 0) {
            args.append("limit=");
            args.append(limit);
        }
        if ((olderThan = this.endpoint.getConfig().getOlderThan()) > 0L) {
            if (args.length() > 0) {
                args.append("&");
            }
            args.append("older_than=");
            args.append(olderThan);
        }
        if ((newerThan = this.endpoint.getConfig().getNewerThan()) > 0L) {
            if (args.length() > 0) {
                args.append("&");
            }
            args.append("newer_than=");
            args.append(newerThan);
        }
        if (ObjectHelper.isNotEmpty((Object)(threaded = this.endpoint.getConfig().getThreaded())) && ("true".equals(threaded) || "extended".equals(threaded))) {
            if (args.length() > 0) {
                args.append("&");
            }
            args.append("threaded=");
            args.append(threaded);
        }
        if (args.length() > 0) {
            url.append("?");
            url.append((CharSequence)args);
        }
        return url.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int poll() throws Exception {
        Exchange exchange = this.endpoint.createExchange();
        try {
            String jsonBody = this.endpoint.getConfig().getRequestor(this.apiUrl).get();
            if (!this.endpoint.getConfig().isUseJson()) {
                ObjectMapper jsonMapper = new ObjectMapper();
                Messages messages = (Messages)jsonMapper.readValue(jsonBody, Messages.class);
                exchange.getIn().setBody((Object)messages);
            } else {
                exchange.getIn().setBody((Object)jsonBody);
            }
            this.getProcessor().process(exchange);
            int n = 1;
            return n;
        }
        finally {
            if (exchange.getException() != null) {
                this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
            }
        }
    }
}

