/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.xquery.springboot;

import javax.annotation.Generated;
import org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Transforms the message using a XQuery template using Saxon.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.SpringBootAutoConfigurationMojo")
@ConfigurationProperties(prefix = "camel.component.xquery")
public class XQueryComponentConfiguration
        extends
            ComponentConfigurationPropertiesCommon {

    /**
     * Whether to enable auto configuration of the xquery component. This is
     * enabled by default.
     */
    private Boolean enabled;
    /**
     * To use the custom ModuleURIResolver. The option is a
     * net.sf.saxon.lib.ModuleURIResolver type.
     */
    private String moduleURIResolver;
    /**
     * To use a custom Saxon configuration. The option is a
     * net.sf.saxon.Configuration type.
     */
    private String configuration;
    /**
     * To set custom Saxon configuration properties. The option is a
     * java.util.Map<java.lang.String,java.lang.Object> type.
     */
    private String configurationProperties;
    /**
     * Whether the component should resolve property placeholders on itself when
     * starting. Only properties which are of String type can use property
     * placeholders.
     */
    private Boolean resolvePropertyPlaceholders = true;

    public String getModuleURIResolver() {
        return moduleURIResolver;
    }

    public void setModuleURIResolver(String moduleURIResolver) {
        this.moduleURIResolver = moduleURIResolver;
    }

    public String getConfiguration() {
        return configuration;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public String getConfigurationProperties() {
        return configurationProperties;
    }

    public void setConfigurationProperties(String configurationProperties) {
        this.configurationProperties = configurationProperties;
    }

    public Boolean getResolvePropertyPlaceholders() {
        return resolvePropertyPlaceholders;
    }

    public void setResolvePropertyPlaceholders(
            Boolean resolvePropertyPlaceholders) {
        this.resolvePropertyPlaceholders = resolvePropertyPlaceholders;
    }
}