/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.jms.temp;

import javax.jms.ConnectionFactory;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;

import org.apache.activemq.command.ActiveMQTempQueue;
import org.apache.activemq.command.ActiveMQTempTopic;
import org.apache.camel.CamelContext;
import org.apache.camel.component.jms.CamelJmsTestHelper;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.jms.JmsProviderMetadata;
import org.apache.camel.test.junit4.CamelTestSupport;
import org.junit.Test;

import static org.apache.camel.component.jms.JmsComponent.jmsComponentAutoAcknowledge;

public class JmsProviderTest extends CamelTestSupport {
    @Test
    public void testTemporaryDestinationTypes() throws Exception {
        JmsEndpoint endpoint = getMandatoryEndpoint("activemq:test.queue", JmsEndpoint.class);
        JmsConfiguration configuration = endpoint.getConfiguration();
        JmsProviderMetadata providerMetadata = configuration.getProviderMetadata();
        assertNotNull("provider", providerMetadata);

        Class<? extends TemporaryQueue> queueType = endpoint.getTemporaryQueueType();
        Class<? extends TemporaryTopic> topicType = endpoint.getTemporaryTopicType();

        log.info("Found queue type: " + queueType);
        log.info("Found topic type: " + topicType);

        assertNotNull("queueType", queueType);
        assertNotNull("topicType", topicType);

        assertEquals("queueType", ActiveMQTempQueue.class, queueType);
        assertEquals("topicType", ActiveMQTempTopic.class, topicType);
    }

    protected CamelContext createCamelContext() throws Exception {
        CamelContext camelContext = super.createCamelContext();

        ConnectionFactory connectionFactory = CamelJmsTestHelper.createConnectionFactory();
        camelContext.addComponent("activemq", jmsComponentAutoAcknowledge(connectionFactory));

        return camelContext;
    }
}
