/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.google.calendar;

import java.util.Map;
import java.util.Map.Entry;

import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;

import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.google.calendar.internal.GoogleCalendarApiName;
import org.apache.camel.support.IntrospectionSupport;
import org.apache.camel.support.component.AbstractApiConsumer;

/**
 * The GoogleCalendar consumer.
 */
public class GoogleCalendarConsumer extends AbstractApiConsumer<GoogleCalendarApiName, GoogleCalendarConfiguration> {

    public GoogleCalendarConsumer(GoogleCalendarEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }
    
    @Override
    protected Object doInvokeMethod(Map<String, Object> properties) throws RuntimeCamelException {
        AbstractGoogleClientRequest request = (AbstractGoogleClientRequest) super.doInvokeMethod(properties);
        try {
            TypeConverter typeConverter = getEndpoint().getCamelContext().getTypeConverter();
            for (Entry<String, Object> p : properties.entrySet()) {
                IntrospectionSupport.setProperty(typeConverter, request, p.getKey(), p.getValue());
            }
            return request.execute();
        } catch (Exception e) {
            throw new RuntimeCamelException(e);
        }
    }    
    
}
