/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.websocket.springboot;

import javax.annotation.Generated;
import org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * The websocket component provides websocket endpoints with Jetty for
 * communicating with clients using websocket.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.SpringBootAutoConfigurationMojo")
@ConfigurationProperties(prefix = "camel.component.websocket")
public class WebsocketComponentConfiguration
        extends
            ComponentConfigurationPropertiesCommon {

    /**
     * Whether to enable auto configuration of the websocket component. This is
     * enabled by default.
     */
    private Boolean enabled;
    /**
     * Set a resource path for static resources (such as .html files etc). The
     * resources can be loaded from classpath, if you prefix with classpath:,
     * otherwise the resources is loaded from file system or from JAR files. For
     * example to load from root classpath use classpath:., or
     * classpath:WEB-INF/static If not configured (eg null) then no static
     * resource is in use.
     */
    private String staticResources;
    /**
     * The hostname. The default value is 0.0.0.0
     */
    private String host = "0.0.0.0";
    /**
     * The port number. The default value is 9292
     */
    private Integer port = 9292;
    /**
     * The password for the keystore when using SSL.
     */
    private String sslKeyPassword;
    /**
     * The password when using SSL.
     */
    private String sslPassword;
    /**
     * The path to the keystore.
     */
    private String sslKeystore;
    /**
     * If this option is true, Jetty JMX support will be enabled for this
     * endpoint. See Jetty JMX support for more details.
     */
    private Boolean enableJmx = false;
    /**
     * To set a value for minimum number of threads in server thread pool.
     * MaxThreads/minThreads or threadPool fields are required due to switch to
     * Jetty9. The default values for minThreads is 1.
     */
    private Integer minThreads;
    /**
     * To set a value for maximum number of threads in server thread pool.
     * MaxThreads/minThreads or threadPool fields are required due to switch to
     * Jetty9. The default values for maxThreads is 1 2 noCores.
     */
    private Integer maxThreads;
    /**
     * To use a custom thread pool for the server. MaxThreads/minThreads or
     * threadPool fields are required due to switch to Jetty9. The option is a
     * org.eclipse.jetty.util.thread.ThreadPool type.
     */
    private String threadPool;
    /**
     * To configure security using SSLContextParameters. The option is a
     * org.apache.camel.support.jsse.SSLContextParameters type.
     */
    private String sslContextParameters;
    /**
     * Enable usage of global SSL context parameters.
     */
    private Boolean useGlobalSslContextParameters = false;
    /**
     * To configure a map which contains custom WebSocketFactory for sub
     * protocols. The key in the map is the sub protocol. The default key is
     * reserved for the default implementation. The option is a
     * java.util.Map<java
     * .lang.String,org.apache.camel.component.websocket.WebSocketFactory> type.
     */
    private String socketFactory;
    /**
     * Whether the component should resolve property placeholders on itself when
     * starting. Only properties which are of String type can use property
     * placeholders.
     */
    private Boolean resolvePropertyPlaceholders = true;

    public String getStaticResources() {
        return staticResources;
    }

    public void setStaticResources(String staticResources) {
        this.staticResources = staticResources;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getSslKeyPassword() {
        return sslKeyPassword;
    }

    public void setSslKeyPassword(String sslKeyPassword) {
        this.sslKeyPassword = sslKeyPassword;
    }

    public String getSslPassword() {
        return sslPassword;
    }

    public void setSslPassword(String sslPassword) {
        this.sslPassword = sslPassword;
    }

    public String getSslKeystore() {
        return sslKeystore;
    }

    public void setSslKeystore(String sslKeystore) {
        this.sslKeystore = sslKeystore;
    }

    public Boolean getEnableJmx() {
        return enableJmx;
    }

    public void setEnableJmx(Boolean enableJmx) {
        this.enableJmx = enableJmx;
    }

    public Integer getMinThreads() {
        return minThreads;
    }

    public void setMinThreads(Integer minThreads) {
        this.minThreads = minThreads;
    }

    public Integer getMaxThreads() {
        return maxThreads;
    }

    public void setMaxThreads(Integer maxThreads) {
        this.maxThreads = maxThreads;
    }

    public String getThreadPool() {
        return threadPool;
    }

    public void setThreadPool(String threadPool) {
        this.threadPool = threadPool;
    }

    public String getSslContextParameters() {
        return sslContextParameters;
    }

    public void setSslContextParameters(String sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public Boolean getUseGlobalSslContextParameters() {
        return useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(
            Boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    public String getSocketFactory() {
        return socketFactory;
    }

    public void setSocketFactory(String socketFactory) {
        this.socketFactory = socketFactory;
    }

    public Boolean getResolvePropertyPlaceholders() {
        return resolvePropertyPlaceholders;
    }

    public void setResolvePropertyPlaceholders(
            Boolean resolvePropertyPlaceholders) {
        this.resolvePropertyPlaceholders = resolvePropertyPlaceholders;
    }
}