/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.model.cloud.springboot;

import java.util.Map;
import javax.annotation.Generated;

/**
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.SpringBootAutoConfigurationMojo")
public class ConsulServiceCallServiceDiscoveryConfigurationCommon {

    /**
     * The Consul agent URL
     */
    private String url;
    /**
     * The data center
     */
    private String datacenter;
    /**
     * Sets the ACL token to be used with Consul
     */
    private String aclToken;
    /**
     * Sets the username to be used for basic authentication
     */
    private String userName;
    /**
     * Sets the password to be used for basic authentication
     */
    private String password;
    /**
     * Connect timeout for OkHttpClient
     */
    private Long connectTimeoutMillis;
    /**
     * Read timeout for OkHttpClient
     */
    private Long readTimeoutMillis;
    /**
     * Write timeout for OkHttpClient
     */
    private Long writeTimeoutMillis;
    /**
     * The seconds to wait for a watch event, default 10 seconds
     */
    private Integer blockSeconds = 10;
    /**
     * Set client properties to use. These properties are specific to what
     * service call implementation are in use. For example if using ribbon, then
     * the client properties are define in
     * com.netflix.client.config.CommonClientConfigKey.
     */
    private Map<String, String> properties;

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDatacenter() {
        return datacenter;
    }

    public void setDatacenter(String datacenter) {
        this.datacenter = datacenter;
    }

    public String getAclToken() {
        return aclToken;
    }

    public void setAclToken(String aclToken) {
        this.aclToken = aclToken;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Long getConnectTimeoutMillis() {
        return connectTimeoutMillis;
    }

    public void setConnectTimeoutMillis(Long connectTimeoutMillis) {
        this.connectTimeoutMillis = connectTimeoutMillis;
    }

    public Long getReadTimeoutMillis() {
        return readTimeoutMillis;
    }

    public void setReadTimeoutMillis(Long readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
    }

    public Long getWriteTimeoutMillis() {
        return writeTimeoutMillis;
    }

    public void setWriteTimeoutMillis(Long writeTimeoutMillis) {
        this.writeTimeoutMillis = writeTimeoutMillis;
    }

    public Integer getBlockSeconds() {
        return blockSeconds;
    }

    public void setBlockSeconds(Integer blockSeconds) {
        this.blockSeconds = blockSeconds;
    }

    public Map<String, String> getProperties() {
        return properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }
}