/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.etcd;

import mousio.etcd4j.EtcdClient;
import org.apache.camel.Processor;
import org.apache.camel.support.DefaultConsumer;

/**
 * The etcd consumer.
 */
public abstract class AbstractEtcdConsumer extends DefaultConsumer {
    private final EtcdConfiguration configuration;
    private final EtcdNamespace namespace;
    private final String path;

    private EtcdClient client;

    protected AbstractEtcdConsumer(AbstractEtcdEndpoint endpoint, Processor processor, EtcdConfiguration configuration, EtcdNamespace namespace, String path) {
        super(endpoint, processor);

        this.configuration = configuration;
        this.namespace = namespace;
        this.path = path;
        this.client = null;
    }

    @Override
    protected void doStop() throws Exception {
        if (client != null) {
            client.close();
        }

        super.doStop();
    }

    protected EtcdClient getClient() throws Exception {
        if (client == null) {
            client = ((EtcdEndpoint)getEndpoint()).createClient();
        }

        return client;
    }

    public EtcdConfiguration getConfiguration() {
        return configuration;
    }

    public EtcdNamespace getNamespace() {
        return namespace;
    }

    public String getPath() {
        return path;
    }
}
