/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan;

import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Service;
import org.apache.camel.component.infinispan.InfinispanConfiguration;
import org.apache.camel.component.infinispan.InfinispanUtil;
import org.apache.camel.util.ObjectHelper;
import org.infinispan.cache.impl.DecoratedCache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.api.BasicCacheContainer;
import org.infinispan.manager.DefaultCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfinispanManager
implements Service {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(InfinispanManager.class);
    private final InfinispanConfiguration configuration;
    private final CamelContext camelContext;
    private BasicCacheContainer cacheContainer;
    private boolean isManagedCacheContainer;

    public InfinispanManager() {
        this.camelContext = null;
        this.configuration = new InfinispanConfiguration();
        this.configuration.setCacheContainer((BasicCacheContainer)new DefaultCacheManager(true));
    }

    public InfinispanManager(InfinispanConfiguration configuration) {
        this(null, configuration);
    }

    public InfinispanManager(CamelContext camelContext, InfinispanConfiguration configuration) {
        this.camelContext = camelContext;
        this.configuration = configuration;
    }

    public void start() throws Exception {
        this.cacheContainer = this.configuration.getCacheContainer();
        if (this.cacheContainer == null) {
            Object containerConf = this.configuration.getCacheContainerConfiguration();
            if (containerConf != null) {
                if (containerConf instanceof Configuration) {
                    this.cacheContainer = new RemoteCacheManager((Configuration)containerConf, true);
                } else if (containerConf instanceof org.infinispan.configuration.cache.Configuration) {
                    this.cacheContainer = new DefaultCacheManager((org.infinispan.configuration.cache.Configuration)containerConf, true);
                } else {
                    throw new IllegalArgumentException("Unsupported CacheContainer Configuration type: " + containerConf.getClass());
                }
            }
            if (this.cacheContainer == null && this.configuration.getHosts() != null) {
                ConfigurationBuilder builder = new ConfigurationBuilder();
                builder.addServers(this.configuration.getHosts());
                if (this.camelContext != null && this.camelContext.getApplicationContextClassLoader() != null) {
                    builder.classLoader(this.camelContext.getApplicationContextClassLoader());
                } else {
                    builder.classLoader(Thread.currentThread().getContextClassLoader());
                }
                Properties properties = new Properties();
                if (ObjectHelper.isNotEmpty((Object)this.configuration.getConfigurationUri())) {
                    properties.putAll((Map<?, ?>)InfinispanUtil.loadProperties(this.camelContext, this.configuration.getConfigurationUri()));
                }
                if (ObjectHelper.isNotEmpty(this.configuration.getConfigurationProperties())) {
                    properties.putAll(this.configuration.getConfigurationProperties());
                }
                if (!properties.isEmpty()) {
                    builder.withProperties(properties);
                }
                this.cacheContainer = new RemoteCacheManager(builder.build(), true);
            }
            if (this.cacheContainer == null) {
                if (ObjectHelper.isNotEmpty((Object)this.configuration.getConfigurationUri())) {
                    try (InputStream is = InfinispanUtil.openInputStream(this.camelContext, this.configuration.getConfigurationUri());){
                        this.cacheContainer = new DefaultCacheManager(is, true);
                    }
                } else {
                    this.cacheContainer = new DefaultCacheManager(new org.infinispan.configuration.cache.ConfigurationBuilder().build());
                }
            }
            this.isManagedCacheContainer = true;
        }
    }

    public void stop() throws Exception {
        if (this.isManagedCacheContainer) {
            this.cacheContainer.stop();
        }
    }

    public BasicCacheContainer getCacheContainer() {
        return this.cacheContainer;
    }

    public boolean isCacheContainerEmbedded() {
        return InfinispanUtil.isEmbedded(this.cacheContainer);
    }

    public boolean isCacheContainerRemote() {
        return InfinispanUtil.isRemote(this.cacheContainer);
    }

    public <K, V> BasicCache<K, V> getCache(String cacheName) {
        BasicCache cache;
        if (ObjectHelper.isEmpty((Object)cacheName)) {
            cache = this.cacheContainer.getCache();
            cacheName = cache.getName();
        } else {
            cache = this.cacheContainer.getCache(cacheName);
        }
        LOGGER.trace("Cache[{}]", (Object)cacheName);
        if (this.configuration.hasFlags() && InfinispanUtil.isEmbedded(cache)) {
            cache = new DecoratedCache(InfinispanUtil.asAdvanced(cache), this.configuration.getFlags());
        }
        return cache;
    }

    public <K, V> BasicCache<K, V> getCache(String cacheName, boolean forceReturnValue) {
        if (this.isCacheContainerRemote()) {
            RemoteCache cache;
            if (ObjectHelper.isEmpty((Object)cacheName)) {
                cache = InfinispanUtil.asRemote(this.cacheContainer).getCache(forceReturnValue);
                cacheName = cache.getName();
            } else {
                cache = InfinispanUtil.asRemote(this.cacheContainer).getCache(cacheName, forceReturnValue);
            }
            LOGGER.trace("Cache[{}]", (Object)cacheName);
            return cache;
        }
        return this.getCache(cacheName);
    }

    public <K, V> BasicCache<K, V> getCache(Exchange exchange, String defaultCache) {
        return this.getCache(exchange.getIn(), defaultCache);
    }

    public <K, V> BasicCache<K, V> getCache(Message message, String defaultCache) {
        BasicCache<K, V> cache = this.getCache((String)message.getHeader("CamelInfinispanCacheName", (Object)defaultCache, String.class));
        return message.getHeader("CamelInfinispanIgnoreReturnValues") != null ? cache : InfinispanUtil.ignoreReturnValuesCache(cache);
    }
}

