/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.crypto.cms.sig;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.component.crypto.cms.common.CryptoCmsUnmarshaller;
import org.apache.camel.component.crypto.cms.exception.CryptoCmsException;
import org.apache.camel.component.crypto.cms.exception.CryptoCmsFormatException;
import org.apache.camel.component.crypto.cms.exception.CryptoCmsNoCertificateForSignerInfoException;
import org.apache.camel.component.crypto.cms.exception.CryptoCmsNoCertificateForSignerInfosException;
import org.apache.camel.component.crypto.cms.exception.CryptoCmsSignatureException;
import org.apache.camel.component.crypto.cms.exception.CryptoCmsSignatureInvalidContentHashException;
import org.apache.camel.component.crypto.cms.exception.CryptoCmsVerifierCertificateNotValidException;
import org.apache.camel.component.crypto.cms.sig.SignedDataVerifierConfiguration;
import org.apache.camel.converter.stream.OutputStreamBuilder;
import org.apache.camel.util.IOHelper;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.CMSSignerDigestMismatchException;
import org.bouncycastle.cms.CMSVerifierCertificateNotValidException;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Selector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignedDataVerifier
extends CryptoCmsUnmarshaller {
    private static final Logger LOG = LoggerFactory.getLogger(SignedDataVerifier.class);
    private final SignedDataVerifierConfiguration conf;

    public SignedDataVerifier(SignedDataVerifierConfiguration config) {
        super(config);
        this.conf = config;
    }

    @Override
    protected Object unmarshalInternal(InputStream is, Exchange exchange) throws Exception {
        CMSSignedDataParser sp;
        try {
            sp = new CMSSignedDataParser(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build(), is);
        }
        catch (CMSException e) {
            throw new CryptoCmsFormatException(this.getFormatErrorMessage(), e);
        }
        OutputStreamBuilder output = this.getOutputStream(sp, exchange);
        this.debugLog(sp);
        this.verify(sp, exchange);
        return output.build();
    }

    protected String getFormatErrorMessage() {
        return "Message has invalid format. It was not possible to parse the message into a PKCS7/CMS content info object containing PKCS7/CMS Signed Data.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OutputStreamBuilder getOutputStream(CMSSignedDataParser sp, Exchange exchange) throws Exception {
        OutputStreamBuilder osb;
        block7: {
            InputStream data;
            try {
                data = sp.getSignedContent().getContentStream();
            }
            catch (NullPointerException e) {
                throw this.getContentMissingException(e);
            }
            osb = OutputStreamBuilder.withExchange((Exchange)exchange);
            try {
                if (data == null) break block7;
                try {
                    IOHelper.copy((InputStream)data, (OutputStream)osb);
                }
                finally {
                    IOHelper.close((Closeable)data);
                }
            }
            catch (IOException e) {
                throw new CryptoCmsException("Error during reading the signed content of the signed data object", e);
            }
        }
        return osb;
    }

    protected CryptoCmsException getContentMissingException(NullPointerException e) {
        return new CryptoCmsException("PKCS7/CMS signature validation not possible: The content for which the hash-value must be calculated is missing in the PKCS7/CMS signed data instance. Please check the configuration of the sender of the PKCS7/CMS signature.", e);
    }

    protected void debugLog(CMSSignedDataParser sp) throws CMSException {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        SignerInformationStore signers = sp.getSignerInfos();
        Set messageDigestAlgorithms = sp.getDigestAlgorithmIDs();
        for (AlgorithmIdentifier algorithm : messageDigestAlgorithms) {
            LOG.debug("Message digest algorithm: {}", (Object)algorithm.getAlgorithm().getId());
        }
        LOG.debug("Included Signer Infos:");
        int i = 0;
        for (SignerInformation signer : signers.getSigners()) {
            Hashtable unAuthAtts;
            Hashtable authAttTable;
            LOG.debug("    Signer {}: {}", new Object[]{++i, this.signerInformationToString(signer)});
            if (signer.getSignedAttributes() != null && (authAttTable = signer.getSignedAttributes().toHashtable()) != null) {
                LOG.debug("    Signed attributes of signer {}: {}", (Object)i, (Object)this.attributesToString(authAttTable));
            }
            if (signer.getUnsignedAttributes() == null || (unAuthAtts = signer.getUnsignedAttributes().toHashtable()) == null) continue;
            LOG.debug("    Unsigned attributes of signer {}: {}", (Object)i, (Object)this.attributesToString(unAuthAtts));
        }
    }

    protected void verify(CMSSignedDataParser signed, Exchange exchange) throws Exception {
        SignerInformationStore signers = this.getNonEmptySenderInfos(signed);
        Collection<X509Certificate> allowedVerifyCerts = this.conf.getCertificates(exchange);
        if (allowedVerifyCerts.isEmpty()) {
            throw new CryptoCmsNoCertificateForSignerInfosException("Cannot verify the signatures of the PKCS7/CMS Signed Data object: No verifier certificate is configured.");
        }
        JcaCertStore certStore = new JcaCertStore(allowedVerifyCerts);
        boolean atLeastOneSignatureVerified = false;
        for (SignerInformation signer : signers.getSigners()) {
            Collection certCollection = certStore.getMatches((Selector)signer.getSID());
            if (certCollection.isEmpty()) {
                if (!this.conf.isVerifySignaturesOfAllSigners(exchange).booleanValue()) continue;
                throw new CryptoCmsNoCertificateForSignerInfoException("KCS7/CMS signature verification failed. The public key for the signer information with" + this.signerInformationToString(signer) + " cannot be found in the configured certificates: " + this.certsToString(allowedVerifyCerts));
            }
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            try {
                if (signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(cert))) {
                    LOG.debug("Verification successful");
                    atLeastOneSignatureVerified = true;
                    if (this.conf.isVerifySignaturesOfAllSigners(exchange).booleanValue()) continue;
                    return;
                }
                throw new CryptoCmsSignatureException("PKCS7/CMS signature verification failed for signer information with " + this.issuerSerialNumberSubject(cert));
            }
            catch (CMSSignerDigestMismatchException e) {
                throw new CryptoCmsSignatureInvalidContentHashException("PKCS7/CMS signature verification failed for signer information with " + this.issuerSerialNumberSubject(cert) + ". Calculated hash differs from the signed hash value. Either the message content does not correspond to the signature or the message might be tampered.", e);
            }
            catch (CMSVerifierCertificateNotValidException e) {
                throw new CryptoCmsVerifierCertificateNotValidException("PKCS7/CMS signature verification failed for signer information with " + this.issuerSerialNumberSubject(cert) + ". Certificate was not valid at the signing time.", e);
            }
        }
        if (!atLeastOneSignatureVerified) {
            throw new CryptoCmsNoCertificateForSignerInfosException("Cannot verify the signature of the PKCS7/CMS signed data object with the certificates " + this.certsToString(allowedVerifyCerts) + " specified in the configuration. The signers in the signed data object are: " + this.signersToString(signers));
        }
    }

    SignerInformationStore getNonEmptySenderInfos(CMSSignedDataParser signed) throws CryptoCmsException, CMSException {
        SignerInformationStore senders = signed.getSignerInfos();
        if (senders.size() == 0) {
            throw new CryptoCmsException("Sent CMS/PKCS7 signed data message is incorrect. No signer info found in signed data. Correct the sent message.");
        }
        return senders;
    }

    protected String signerInformationToString(SignerInformation sigInfo) {
        if (sigInfo == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("ContentTypeOID=");
        sb.append(sigInfo.getContentType());
        sb.append(", Issuer=");
        sb.append(sigInfo.getSID().getIssuer());
        sb.append(", SerialNumber=");
        sb.append(sigInfo.getSID().getSerialNumber());
        sb.append(", SignerInfoVersion=");
        sb.append(sigInfo.getVersion());
        sb.append(", SignatureAlgorithmOID=");
        sb.append(sigInfo.getDigestAlgOID());
        sb.append(", EncryptionAlgorithmOID=");
        sb.append(sigInfo.getEncryptionAlgOID());
        sb.append(", isCounterSignature=");
        sb.append(sigInfo.isCounterSignature());
        return sb.toString();
    }

    protected String signersToString(SignerInformationStore signers) {
        if (signers == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Collection sigInfos = signers.getSigners();
        int size = sigInfos.size();
        int counter = 0;
        for (SignerInformation sigInfo : sigInfos) {
            ++counter;
            sb.append('[');
            sb.append("Issuer=");
            sb.append(sigInfo.getSID().getIssuer());
            sb.append(", SerialNumber=");
            sb.append(sigInfo.getSID().getSerialNumber());
            sb.append(']');
            if (counter >= size) continue;
            sb.append("; ");
        }
        return sb.toString();
    }

    protected String attributesToString(Hashtable<String, Attribute> attributes) {
        if (attributes == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Attribute attr : attributes.values()) {
            sb.append(attr.getAttrType());
            if (CMSAttributes.signingTime.equals((ASN1Primitive)attr.getAttrType()) || CMSAttributes.messageDigest.equals((ASN1Primitive)attr.getAttrType()) || CMSAttributes.cmsAlgorithmProtect.equals((ASN1Primitive)attr.getAttrType()) || "contentType".equals(attr.getAttrType())) {
                sb.append("=");
                sb.append(attr.getAttrValues());
            }
            sb.append(",");
        }
        return sb.toString();
    }
}

