/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mvel;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.mvel.MvelEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.ResourceHelper;

public class MvelComponent
extends UriEndpointComponent {
    @Metadata(defaultValue="false")
    private boolean allowTemplateFromHeader;
    @Metadata(defaultValue="false")
    private boolean allowContextMapAll;

    public MvelComponent() {
        super(MvelEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        boolean cache = (Boolean)this.getAndRemoveParameter(parameters, "contentCache", Boolean.class, Boolean.TRUE);
        MvelEndpoint answer = new MvelEndpoint(uri, this, remaining);
        answer.setContentCache(cache);
        answer.setAllowTemplateFromHeader(this.allowTemplateFromHeader);
        answer.setAllowContextMapAll(this.allowContextMapAll);
        this.setProperties((Object)answer, parameters);
        if (ResourceHelper.isHttpUri((String)remaining)) {
            remaining = ResourceHelper.appendParameters((String)remaining, parameters);
            answer.setResourceUri(remaining);
        }
        return answer;
    }

    public boolean isAllowTemplateFromHeader() {
        return this.allowTemplateFromHeader;
    }

    public void setAllowTemplateFromHeader(boolean allowTemplateFromHeader) {
        this.allowTemplateFromHeader = allowTemplateFromHeader;
    }

    public boolean isAllowContextMapAll() {
        return this.allowContextMapAll;
    }

    public void setAllowContextMapAll(boolean allowContextMapAll) {
        this.allowContextMapAll = allowContextMapAll;
    }
}

