/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.embedded;

import org.apache.camel.component.infinispan.InfinispanConfiguration;
import org.apache.camel.component.infinispan.InfinispanConsumer;
import org.apache.camel.component.infinispan.InfinispanConsumerHandler;
import org.apache.camel.component.infinispan.InfinispanEventListener;
import org.apache.camel.component.infinispan.InfinispanUtil;
import org.apache.camel.component.infinispan.embedded.InfinispanAsyncClusteredEventListener;
import org.apache.camel.component.infinispan.embedded.InfinispanAsyncLocalEventListener;
import org.apache.camel.component.infinispan.embedded.InfinispanSyncClusteredEventListener;
import org.apache.camel.component.infinispan.embedded.InfinispanSyncLocalEventListener;
import org.infinispan.Cache;

public final class InfinispanConsumerEmbeddedHandler
implements InfinispanConsumerHandler {
    public static final InfinispanConsumerHandler INSTANCE = new InfinispanConsumerEmbeddedHandler();

    private InfinispanConsumerEmbeddedHandler() {
    }

    @Override
    public InfinispanEventListener start(InfinispanConsumer consumer) {
        InfinispanEventListener listener;
        Cache<Object, Object> embeddedCache = InfinispanUtil.asEmbedded(consumer.getCache());
        InfinispanConfiguration configuration = consumer.getConfiguration();
        if (configuration.hasCustomListener()) {
            listener = configuration.getCustomListener();
            ((InfinispanEventListener)listener).setInfinispanConsumer(consumer);
        } else {
            listener = configuration.isClusteredListener() ? (configuration.isSync() ? new InfinispanSyncClusteredEventListener(consumer, configuration.getEventTypes()) : new InfinispanAsyncClusteredEventListener(consumer, configuration.getEventTypes())) : (configuration.isSync() ? new InfinispanSyncLocalEventListener(consumer, configuration.getEventTypes()) : new InfinispanAsyncLocalEventListener(consumer, configuration.getEventTypes()));
        }
        embeddedCache.addListener((Object)listener);
        return listener;
    }

    @Override
    public void stop(InfinispanConsumer consumer) {
        Cache<Object, Object> embeddedCache = InfinispanUtil.asEmbedded(consumer.getCache());
        embeddedCache.removeListener((Object)consumer.getListener());
    }
}

