/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.guice.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scope;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.apache.camel.guice.inject.Injectors;
import org.apache.camel.guice.support.CloseFailedException;
import org.apache.camel.guice.support.HasScopeAnnotation;
import org.apache.camel.guice.support.internal.CloseErrorsImpl;
import org.apache.camel.guice.util.CachingProvider;

public class CloseableScope
implements Scope,
HasScopeAnnotation {
    private Class<? extends Annotation> scopeAnnotation;
    private final Map<Key<?>, Object> map = Maps.newHashMap();
    @Inject
    private Injector injector;

    public CloseableScope(Class<? extends Annotation> scopeAnnotation) {
        this.scopeAnnotation = scopeAnnotation;
    }

    public <T> Provider<T> scope(final Key<T> key, final Provider<T> creator) {
        return new CachingProvider<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public T get() {
                Object o;
                Map map = CloseableScope.this.map;
                synchronized (map) {
                    o = CloseableScope.this.map.get(key);
                    if (o == null) {
                        o = creator.get();
                        CloseableScope.this.map.put(key, o);
                    }
                }
                return o;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public T getCachedValue() {
                Map map = CloseableScope.this.map;
                synchronized (map) {
                    return CloseableScope.this.map.get(key);
                }
            }
        };
    }

    public void close() throws CloseFailedException {
        this.close(this.injector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Injector injector) throws CloseFailedException {
        Preconditions.checkNotNull((Object)injector, (Object)"injector");
        CloseErrorsImpl errors = new CloseErrorsImpl(this);
        Injectors.close(injector, this.scopeAnnotation, errors);
        Map<Key<?>, Object> map = this.map;
        synchronized (map) {
            this.map.clear();
        }
        errors.throwIfNecessary();
    }

    @Override
    public Class<? extends Annotation> getScopeAnnotation() {
        return this.scopeAnnotation;
    }
}

