/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bonita.producer;

import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.bonita.BonitaConfiguration;
import org.apache.camel.component.bonita.BonitaEndpoint;
import org.apache.camel.component.bonita.api.BonitaAPI;
import org.apache.camel.component.bonita.api.BonitaAPIBuilder;
import org.apache.camel.component.bonita.api.model.ProcessDefinitionResponse;
import org.apache.camel.component.bonita.api.util.BonitaAPIConfig;
import org.apache.camel.component.bonita.producer.BonitaProducer;

public class BonitaStartProducer
extends BonitaProducer {
    public BonitaStartProducer(BonitaEndpoint endpoint, BonitaConfiguration configuration) {
        super(endpoint, configuration);
    }

    public void process(Exchange exchange) throws Exception {
        String hostname = this.configuration.getHostname();
        String port = this.configuration.getPort();
        String processName = this.configuration.getProcessName();
        String username = this.configuration.getUsername();
        String password = this.configuration.getPassword();
        BonitaAPIConfig bonitaAPIConfig = new BonitaAPIConfig(hostname, port, username, password);
        BonitaAPI bonitaApi = BonitaAPIBuilder.build(bonitaAPIConfig);
        ProcessDefinitionResponse processDefinition = bonitaApi.getProcessDefinition(processName);
        bonitaApi.startCase(processDefinition, (Map)exchange.getIn().getBody(Map.class));
    }
}

