/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.websocket.jsr356;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import javax.websocket.server.ServerContainer;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.IOHelper;
import org.apache.camel.websocket.jsr356.CamelServerEndpoint;
import org.apache.camel.websocket.jsr356.JSR356Endpoint;

public class JSR356WebSocketComponent
extends DefaultComponent {
    private static final Map<String, ContextBag> SERVER_CONTAINERS = new ConcurrentHashMap<String, ContextBag>();
    @Metadata(label="sessionCount")
    protected int sessionCount;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) {
        return new JSR356Endpoint(this, uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendMessage(Session session, Object message) throws IOException {
        RemoteEndpoint.Basic basicRemote = session.getBasicRemote();
        Session session2 = session;
        synchronized (session2) {
            if (String.class.isInstance(message)) {
                basicRemote.sendText(String.valueOf(message));
            } else if (ByteBuffer.class.isInstance(message)) {
                basicRemote.sendBinary((ByteBuffer)ByteBuffer.class.cast(message));
            } else if (InputStream.class.isInstance(message)) {
                IOHelper.copy((InputStream)((InputStream)InputStream.class.cast(message)), (OutputStream)basicRemote.getSendStream());
            } else {
                throw new IllegalArgumentException("Unsupported input: " + message);
            }
        }
    }

    public static void registerServer(String contextPath, ServerContainer container) {
        SERVER_CONTAINERS.put(contextPath, new ContextBag(container));
    }

    public static void unregisterServer(String contextPath) {
        SERVER_CONTAINERS.remove(contextPath);
    }

    public static ContextBag getContext(String context) {
        return Optional.ofNullable(context).map(SERVER_CONTAINERS::get).orElseGet(() -> SERVER_CONTAINERS.size() == 1 ? SERVER_CONTAINERS.values().iterator().next() : SERVER_CONTAINERS.get(""));
    }

    public static final class ContextBag {
        private final ServerContainer container;
        private final Map<String, CamelServerEndpoint> endpoints = new HashMap<String, CamelServerEndpoint>();

        private ContextBag(ServerContainer container) {
            this.container = container;
        }

        public ServerContainer getContainer() {
            return this.container;
        }

        public Map<String, CamelServerEndpoint> getEndpoints() {
            return this.endpoints;
        }
    }
}

